/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.activemq.broker.impl;

import java.util.Objects;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.DestinationFilter;
import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.command.ActiveMQDestination;
import org.opennms.features.activemq.broker.api.ManagedDestination;

public class ManagedDestinationImpl
implements ManagedDestination {
    private final ActiveMQDestination def;
    private final Destination dest;

    public ManagedDestinationImpl(ActiveMQDestination def, Destination dest) {
        this.def = Objects.requireNonNull(def);
        this.dest = Objects.requireNonNull(dest);
    }

    @Override
    public String getName() {
        return this.dest.getName();
    }

    @Override
    public boolean isQueue() {
        return this.def.isQueue();
    }

    @Override
    public boolean isTopic() {
        return this.def.isTopic();
    }

    @Override
    public boolean isTemporary() {
        return this.def.isTemporary();
    }

    @Override
    public long getMessageCount() {
        return this.dest.getDestinationStatistics().getMessages().getCount();
    }

    @Override
    public long getEnqueueCount() {
        return this.dest.getDestinationStatistics().getEnqueues().getCount();
    }

    @Override
    public long getDequeueCount() {
        return this.dest.getDestinationStatistics().getDequeues().getCount();
    }

    @Override
    public boolean isCursorFull() {
        Queue queue = this.toQueue(this.dest);
        if (queue == null) {
            return false;
        }
        if (queue.getMessages() != null) {
            return queue.getMessages().isFull();
        }
        return false;
    }

    @Override
    public void purge() throws Exception {
        Queue queue = this.toQueue(this.dest);
        if (queue == null) {
            throw new UnsupportedOperationException("purge() can only be performed on queues.");
        }
        queue.purge();
    }

    private Queue toQueue(Destination dest) {
        if (dest instanceof Queue) {
            return (Queue)dest;
        }
        if (dest instanceof DestinationFilter) {
            DestinationFilter destFilter = (DestinationFilter)dest;
            return this.toQueue(destFilter.getNext());
        }
        return null;
    }
}

