/*
 * Decompiled with CFR 0.152.
 */
package org.openmbee.mms.storage;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Optional;
import org.apache.tika.mime.MimeTypes;
import org.openmbee.mms.artifacts.storage.ArtifactStorage;
import org.openmbee.mms.core.exceptions.InternalErrorException;
import org.openmbee.mms.core.exceptions.NotFoundException;
import org.openmbee.mms.json.ElementJson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class S3Storage
implements ArtifactStorage {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private AmazonS3 s3Client;
    @Value(value="${s3.endpoint}")
    private String ENDPOINT;
    @Value(value="${s3.access_key:#{null}}")
    private Optional<String> ACCESS_KEY;
    @Value(value="${s3.secret_key:#{null}}")
    private Optional<String> SECRET_KEY;
    @Value(value="${s3.region}")
    private String REGION;
    @Value(value="${s3.bucket:#{null}}")
    private Optional<String> BUCKET;
    private MimeTypes mimeTypes = MimeTypes.getDefaultMimeTypes();

    private AmazonS3 getClient() {
        if (this.s3Client == null) {
            ClientConfiguration clientConfiguration = new ClientConfiguration();
            clientConfiguration.setSignerOverride("AWSS3V4SignerType");
            AmazonS3ClientBuilder builder = (AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.ENDPOINT, this.REGION))).withPathStyleAccessEnabled(Boolean.valueOf(true))).withClientConfiguration(clientConfiguration);
            if (this.ACCESS_KEY.isPresent() && this.SECRET_KEY.isPresent()) {
                BasicAWSCredentials credentials = new BasicAWSCredentials(this.ACCESS_KEY.get(), this.SECRET_KEY.get());
                this.s3Client = (AmazonS3)((AmazonS3ClientBuilder)builder.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)credentials))).build();
            } else {
                this.s3Client = (AmazonS3)((AmazonS3ClientBuilder)builder.withCredentials((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance())).build();
            }
            if (!this.s3Client.doesBucketExistV2(this.getBucket())) {
                try {
                    this.s3Client.createBucket(this.getBucket());
                }
                catch (AmazonS3Exception e) {
                    throw new InternalErrorException((Object)e);
                }
            }
        }
        return this.s3Client;
    }

    public byte[] get(String location, ElementJson element, String mimetype) {
        GetObjectRequest rangeObjectRequest = new GetObjectRequest(this.getBucket(), location);
        try {
            return this.getClient().getObject(rangeObjectRequest).getObjectContent().readAllBytes();
        }
        catch (IOException ioe) {
            throw new NotFoundException((Object)ioe);
        }
    }

    public String store(byte[] data, ElementJson element, String mimetype) {
        String location = this.buildLocation(element, mimetype);
        ObjectMetadata om = new ObjectMetadata();
        om.setContentType(mimetype);
        om.setContentLength((long)data.length);
        PutObjectRequest por = new PutObjectRequest(this.getBucket(), location, (InputStream)new ByteArrayInputStream(data), om);
        try {
            this.getClient().putObject(por);
        }
        catch (RuntimeException e) {
            this.logger.error("Error storing artifact: ", (Throwable)e);
            throw new InternalErrorException((Object)e);
        }
        return location;
    }

    private String buildLocation(ElementJson element, String mimetype) {
        Date today = new Date();
        return String.format("%s/%s/%s/%d", element.getProjectId(), element.getId(), this.getExtension(mimetype), today.getTime());
    }

    private String getExtension(String mime) {
        String extension = "";
        try {
            extension = this.mimeTypes.forName(mime).getExtension().substring(1);
        }
        catch (Exception e) {
            this.logger.error("Error getting extension: ", (Throwable)e);
        }
        return extension;
    }

    private String getBucket() {
        String bucket = "mms";
        if (this.BUCKET.isPresent()) {
            bucket = this.BUCKET.get();
        }
        return bucket;
    }
}

