/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.publish.test;

import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.springframework.beans.factory.FactoryBean;

final class ClientFactoryBean
implements FactoryBean<Object> {
    private static final long TIME_OUT = 60000L;
    private ClientProxyFactoryBean clientProxyFactoryBean;
    private boolean logging = false;
    private Long timeOut;

    ClientFactoryBean() {
    }

    public boolean isLogging() {
        return this.logging;
    }

    public void setLogging(boolean logging) {
        this.logging = logging;
    }

    public Long getTimeOut() {
        if (this.timeOut != null) {
            return this.timeOut;
        }
        return 60000L;
    }

    public void setTimeOut(Long timeOut) {
        if (timeOut == null) {
            throw new IllegalArgumentException("timeOut can't be null");
        }
        this.timeOut = timeOut;
    }

    public ClientProxyFactoryBean getClientProxyFactoryBean() {
        return this.clientProxyFactoryBean;
    }

    public void setClientProxyFactoryBean(ClientProxyFactoryBean clientProxyFactoryBean) {
        if (clientProxyFactoryBean == null) {
            throw new IllegalArgumentException("clientProxyFactoryBean arg can't be null");
        }
        this.clientProxyFactoryBean = clientProxyFactoryBean;
    }

    public Class<?> getObjectType() {
        if (this.getClientProxyFactoryBean() == null) {
            throw new IllegalStateException("clientProxyFactoryBean can't be null");
        }
        if (this.getClientProxyFactoryBean().getServiceClass() == null) {
            throw new IllegalStateException("clientProxyFactoryBean.serviceClass can't be null");
        }
        return this.getClientProxyFactoryBean().getServiceClass();
    }

    public boolean isSingleton() {
        return true;
    }

    protected void prepare(Object client) {
        Client cl = ClientProxy.getClient((Object)client);
        if (this.isLogging()) {
            cl.getInInterceptors().add(new LoggingInInterceptor());
            cl.getOutInterceptors().add(new LoggingOutInterceptor());
        }
        HTTPConduit http = (HTTPConduit)cl.getConduit();
        HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
        httpClientPolicy.setReceiveTimeout(this.getTimeOut().longValue());
        httpClientPolicy.setAllowChunking(false);
        httpClientPolicy.setConnectionTimeout(this.getTimeOut().longValue());
        http.setClient(httpClientPolicy);
    }

    public Object getObject() throws Exception {
        return this.create();
    }

    public Object create() {
        if (this.getClientProxyFactoryBean() == null) {
            throw new IllegalStateException("clientProxyFactoryBean can't be null");
        }
        Object client = this.getClientProxyFactoryBean().create();
        this.prepare(client);
        return client;
    }
}

