/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.publish.test;

import java.util.Collection;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.junit.Before;
import org.openl.rules.ruleservice.core.OpenLService;
import org.openl.rules.ruleservice.management.ServiceManagerImpl;
import org.openl.rules.ruleservice.publish.WebServicesRuleServicePublisher;
import org.openl.rules.ruleservice.publish.test.ClientFactoryBean;
import org.openl.rules.ruleservice.publish.test.ServiceNotFoundException;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class AbstractWebServicesRuleServicePublisherTest
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private static boolean initialized = false;

    @Before
    public void before() {
        if (!initialized) {
            ServiceManagerImpl serviceManager = (ServiceManagerImpl)this.applicationContext.getBean("serviceManager", ServiceManagerImpl.class);
            serviceManager.start();
            initialized = true;
        }
    }

    public final void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public final ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    protected WebServicesRuleServicePublisher getRuleServicePublisher() {
        return (WebServicesRuleServicePublisher)this.getApplicationContext().getBean(WebServicesRuleServicePublisher.class);
    }

    protected Collection<OpenLService> getServices() {
        return this.getRuleServicePublisher().getServices();
    }

    protected OpenLService getServiceByName(String serviceName) throws ServiceNotFoundException {
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName arg can't be null");
        }
        OpenLService service = this.getRuleServicePublisher().getServiceByName(serviceName);
        if (service == null) {
            throw new ServiceNotFoundException(String.format("Service with name=\"%s\" was not found", serviceName));
        }
        return service;
    }

    protected DataBinding getDataBinding(String serviceName) {
        return this.getRuleServicePublisher().getDataBinding(serviceName);
    }

    protected Object getClient(String serviceName) throws ServiceNotFoundException {
        return this.getClient(serviceName, (String)null);
    }

    protected Object getClient(String serviceName, String address) throws ServiceNotFoundException {
        return this.getClient(serviceName, address, null);
    }

    protected <T> T getClient(String serviceName, Class<T> clazz) throws ServiceNotFoundException {
        return this.getClient(serviceName, null, clazz);
    }

    protected <T> T getClient(String serviceName, String address, Class<T> clazz) throws ServiceNotFoundException {
        return this.getClient(serviceName, address, clazz, null);
    }

    protected <T> T getClient(String serviceName, String address, Class<T> clazz, DataBinding dataBinding) throws ServiceNotFoundException {
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName arg can't be null");
        }
        OpenLService service = this.getServiceByName(serviceName);
        DataBinding dataBindingForClient = null;
        Class clazzForClient = null;
        String addressForClient = null;
        clazzForClient = clazz == null ? service.getServiceClass() : clazz;
        if (dataBinding == null) {
            dataBindingForClient = this.getDataBinding(serviceName);
        }
        addressForClient = address == null ? this.getRuleServicePublisher().getBaseAddress() + service.getUrl() : address;
        ClientProxyFactoryBean clientProxyFactoryBean = new ClientProxyFactoryBean();
        clientProxyFactoryBean.setServiceClass(clazzForClient);
        clientProxyFactoryBean.setAddress(addressForClient);
        if (dataBindingForClient != null) {
            clientProxyFactoryBean.setDataBinding(dataBindingForClient);
        }
        ClientFactoryBean clientFactoryBean = new ClientFactoryBean();
        clientFactoryBean.setClientProxyFactoryBean(clientProxyFactoryBean);
        return (T)clientFactoryBean.create();
    }

    protected Client getDynamicClientByServiceName(String serviceName) throws ServiceNotFoundException {
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName arg can't be null");
        }
        OpenLService service = this.getServiceByName(serviceName);
        String wsdlLocation = this.buildWsdlLocation(this.getRuleServicePublisher().getBaseAddress(), service.getUrl());
        return this.getDynamicClient(wsdlLocation);
    }

    protected String buildWsdlLocation(String baseUrl, String serviceUrl) {
        return baseUrl + serviceUrl + "?wsdl";
    }

    protected Client getDynamicClient(String wsdlLocation) {
        if (wsdlLocation == null) {
            throw new IllegalArgumentException("wsdlLocation can't be null");
        }
        JaxWsDynamicClientFactory clientFactory = JaxWsDynamicClientFactory.newInstance();
        Client client = clientFactory.createClient(wsdlLocation);
        return client;
    }
}

