/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.publish;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.jaxrs.provider.json.JSONProvider;
import org.openl.rules.ruleservice.core.OpenLService;
import org.openl.rules.ruleservice.core.RuleServiceDeployException;
import org.openl.rules.ruleservice.core.RuleServiceRedeployException;
import org.openl.rules.ruleservice.core.RuleServiceUndeployException;
import org.openl.rules.ruleservice.publish.RuleServicePublisher;
import org.openl.rules.ruleservice.servlet.AvailableServicesGroup;
import org.openl.rules.ruleservice.servlet.ServiceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;

public class RESTServicesRuleServicePublisher
implements RuleServicePublisher,
AvailableServicesGroup {
    private final Logger log = LoggerFactory.getLogger(RESTServicesRuleServicePublisher.class);
    private ObjectFactory<? extends JAXRSServerFactoryBean> serverFactory;
    private Map<OpenLService, Server> runningServices = new HashMap<OpenLService, Server>();
    private String baseAddress;
    private List<ServiceInfo> availableServices = new ArrayList<ServiceInfo>();

    public String getBaseAddress() {
        return this.baseAddress;
    }

    public void setBaseAddress(String baseAddress) {
        this.baseAddress = baseAddress;
    }

    public ObjectFactory<?> getServerFactory() {
        return this.serverFactory;
    }

    public void setServerFactory(ObjectFactory<? extends JAXRSServerFactoryBean> serverFactory) {
        this.serverFactory = serverFactory;
    }

    JAXRSServerFactoryBean getServerFactoryBean() {
        if (this.serverFactory != null) {
            return (JAXRSServerFactoryBean)this.serverFactory.getObject();
        }
        JAXRSServerFactoryBean sfb = new JAXRSServerFactoryBean();
        JSONProvider provider = new JSONProvider();
        provider.setWriteXsiType(false);
        sfb.setProvider((Object)provider);
        return sfb;
    }

    public void deploy(OpenLService service) throws RuleServiceDeployException {
        JAXRSServerFactoryBean svrFactory = this.getServerFactoryBean();
        svrFactory.setAddress(this.getBaseAddress() + service.getUrl());
        svrFactory.setServiceClass(service.getServiceClass());
        svrFactory.setResourceProvider(service.getServiceClass(), (ResourceProvider)new SingletonResourceProvider(service.getServiceBean()));
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(service.getServiceClass().getClassLoader());
        try {
            Server wsServer = svrFactory.create();
            this.runningServices.put(service, wsServer);
            this.availableServices.add(this.createServiceInfo(service));
            this.log.info("Service \"{}\" with URL \"{}{}\" succesfully deployed.", new Object[]{service.getName(), this.getBaseAddress(), service.getUrl()});
        }
        catch (Throwable t) {
            throw new RuleServiceDeployException(String.format("Failed to deploy service \"%s\"", service.getName()), t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    public Collection<OpenLService> getServices() {
        return Collections.unmodifiableCollection(this.runningServices.keySet());
    }

    public OpenLService getServiceByName(String name) {
        for (OpenLService service : this.runningServices.keySet()) {
            if (!service.getName().equals(name)) continue;
            return service;
        }
        return null;
    }

    public void undeploy(String serviceName) throws RuleServiceUndeployException {
        OpenLService service = this.getServiceByName(serviceName);
        if (service == null) {
            throw new RuleServiceUndeployException(String.format("There is no running service with name \"%s\"", serviceName));
        }
        try {
            this.runningServices.get(service).destroy();
            this.log.info("Service \"{}\" with URL \"{}{}\" succesfully undeployed.", new Object[]{serviceName, this.baseAddress, service.getUrl()});
            this.runningServices.remove(service);
            this.removeServiceInfo(serviceName);
            service.destroy();
        }
        catch (Exception t) {
            throw new RuleServiceUndeployException(String.format("Failed to undeploy service \"%s\"", serviceName), (Throwable)t);
        }
    }

    public void redeploy(OpenLService service) throws RuleServiceRedeployException {
        if (service == null) {
            throw new IllegalArgumentException("service argument can't be null");
        }
        try {
            this.undeploy(service.getName());
            this.deploy(service);
        }
        catch (RuleServiceDeployException e) {
            throw new RuleServiceRedeployException("Service redeploy was failed", (Throwable)e);
        }
        catch (RuleServiceUndeployException e) {
            throw new RuleServiceRedeployException("Service redeploy was failed", (Throwable)e);
        }
    }

    @Override
    public String getGroupName() {
        return "RESTful";
    }

    @Override
    public List<ServiceInfo> getAvailableServices() {
        ArrayList<ServiceInfo> services = new ArrayList<ServiceInfo>(this.availableServices);
        Collections.sort(services, new Comparator<ServiceInfo>(){

            @Override
            public int compare(ServiceInfo o1, ServiceInfo o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        return services;
    }

    private ServiceInfo createServiceInfo(OpenLService service) {
        ArrayList<String> methodNames = new ArrayList<String>();
        for (Method method : service.getServiceClass().getMethods()) {
            methodNames.add(method.getName());
        }
        Collections.sort(methodNames, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        });
        String url = service.getUrl() + "?wadl";
        return new ServiceInfo(new Date(), service.getName(), methodNames, url, "WADL");
    }

    private void removeServiceInfo(String serviceName) {
        Iterator<ServiceInfo> iterator = this.availableServices.iterator();
        while (iterator.hasNext()) {
            ServiceInfo serviceInfo = iterator.next();
            if (!serviceInfo.getName().equals(serviceName)) continue;
            iterator.remove();
            break;
        }
    }
}

