/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.databinding;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;

public class RootClassNamesBindingFactoryBean
implements FactoryBean<Set<String>> {
    private final Logger log = LoggerFactory.getLogger(RootClassNamesBindingFactoryBean.class);
    private String rootClassNames;

    public void setRootClassNames(String rootClassNames) {
        this.rootClassNames = rootClassNames;
    }

    public String getRootClassNames() {
        return this.rootClassNames;
    }

    public Set<String> getObject() throws Exception {
        String[] rootClasses;
        HashSet<String> ret = new HashSet<String>();
        if (this.rootClassNames == null || this.rootClassNames.trim().length() == 0) {
            return ret;
        }
        for (String className : rootClasses = this.rootClassNames.split(",")) {
            if (className == null || className.trim().length() <= 0) continue;
            String trimmedClassName = className.trim();
            ret.add(trimmedClassName);
            this.log.info("{} class is added to the root class names list for WS type binding.", (Object)trimmedClassName);
        }
        return Collections.unmodifiableSet(ret);
    }

    public Class<?> getObjectType() {
        return Set.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

