/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.print;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.openl.util.print.NicePrinterAdaptor;

public class NicePrinter {
    int identStep = 2;
    StringBuffer buffer = null;
    int ident = 0;
    HashMap<Object, Integer> printedObjects = new HashMap();
    int printedID = 0;

    public static String getTypeName(Object obj) {
        return obj.getClass().getName();
    }

    public static String print(Object obj) {
        StringBuffer buf = new StringBuffer(100);
        NicePrinter.print(obj, buf);
        return buf.toString();
    }

    public static void print(Object obj, StringBuffer buf) {
        NicePrinter np = new NicePrinter(buf);
        np.print(obj, new NicePrinterAdaptor());
    }

    public NicePrinter() {
        this(new StringBuffer(100));
    }

    public NicePrinter(StringBuffer buf) {
        this.buffer = buf;
    }

    public void decIdent() {
        --this.ident;
    }

    public StringBuffer getBuffer() {
        return this.buffer;
    }

    public void incIdent() {
        ++this.ident;
    }

    public void print(Object obj, NicePrinterAdaptor adaptor) {
        if (obj == null) {
            adaptor.printNull(this);
            return;
        }
        if (adaptor.isPrimitive(obj)) {
            adaptor.printPrimitive(obj, this);
            return;
        }
        Integer existingID = this.printedObjects.get(obj);
        if (existingID != null) {
            adaptor.printReference(obj, existingID, this);
            return;
        }
        int newID = this.printedID++;
        this.printedObjects.put(obj, new Integer(newID));
        if (obj instanceof Enum) {
            adaptor.printPrimitive(obj, this);
            return;
        }
        if (obj instanceof Map) {
            adaptor.printMap((Map)obj, null, this);
            return;
        }
        if (obj instanceof Collection) {
            adaptor.printCollection((Collection)obj, newID, this);
            return;
        }
        if (obj.getClass().isArray()) {
            adaptor.printArray(obj, newID, this);
            return;
        }
        adaptor.printObject(obj, newID, this);
    }

    public void startNewLine() {
        this.buffer.append('\n');
        for (int i = 0; i < this.ident; ++i) {
            for (int j = 0; j < this.identStep; ++j) {
                this.buffer.append(' ');
            }
        }
    }

    public static interface PrintableObject {
        public void print(NicePrinter var1);
    }
}

