/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.print;

import org.openl.util.print.CategorizedSearchContext;
import org.openl.util.print.DefaultFormat;
import org.openl.util.print.IFormat;
import org.openl.util.print.OutputFilter;
import org.openl.util.print.PrintContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Formatter {
    private static IFormat defaultFormat = new DefaultFormat();

    public static IFormat defaultFormat() {
        return defaultFormat;
    }

    public static String filterCategory() {
        return OutputFilter.class.getName();
    }

    public static StringBuffer format(Object obj, int mode, StringBuffer buf) {
        Object key = obj == null ? "null" : obj.getClass();
        return Formatter.format(obj, mode, buf, key);
    }

    public static StringBuffer format(Object obj, int mode, StringBuffer buf, Object key) {
        OutputFilter filter;
        IFormat format = (IFormat)CategorizedSearchContext.current().find(key, Formatter.formatCategory());
        if (format == null) {
            format = Formatter.defaultFormat();
        }
        if ((filter = (OutputFilter)CategorizedSearchContext.current().find(key, Formatter.filterCategory())) == null) {
            filter = (OutputFilter)CategorizedSearchContext.current().find(Formatter.filterCategory(), Formatter.filterCategory());
        }
        PrintContext cxt = new PrintContext(format, filter);
        return cxt.print(obj, mode, buf);
    }

    public static String formatCategory() {
        return IFormat.class.getName();
    }

    public static void registerFilter(Class<?> c, OutputFilter filter) {
        CategorizedSearchContext.current().register(c == null ? Formatter.filterCategory() : c, Formatter.filterCategory(), filter);
    }

    public static void registerFormat(Class<?> c, IFormat format) {
        CategorizedSearchContext.current().register(c, Formatter.formatCategory(), format);
    }

    public static void unregisterFormat(Class<?> c) {
        CategorizedSearchContext.current().unregister(c, Formatter.formatCategory());
    }
}

