/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.math.stat.StatUtils;
import org.apache.commons.math.stat.descriptive.rank.Median;
import org.openl.util.ArrayTool;

public class MathUtils {
    public static boolean max(byte value1, byte value2) {
        return value1 > value2;
    }

    public static boolean max(short value1, short value2) {
        return value1 > value2;
    }

    public static boolean max(int value1, int value2) {
        return value1 > value2;
    }

    public static boolean max(long value1, long value2) {
        return value1 > value2;
    }

    public static boolean max(float value1, float value2) {
        return value1 > value2;
    }

    public static boolean max(double value1, double value2) {
        return value1 > value2;
    }

    public static byte max(byte[] values) {
        return NumberUtils.max((byte[])values);
    }

    public static short max(short[] values) {
        return NumberUtils.max((short[])values);
    }

    public static int max(int[] values) {
        return NumberUtils.max((int[])values);
    }

    public static long max(long[] values) {
        return NumberUtils.max((long[])values);
    }

    public static float max(float[] values) {
        return NumberUtils.max((float[])values);
    }

    public static double max(double[] values) {
        return NumberUtils.max((double[])values);
    }

    public static boolean min(byte value1, byte value2) {
        return value1 < value2;
    }

    public static boolean min(short value1, short value2) {
        return value1 < value2;
    }

    public static boolean min(int value1, int value2) {
        return value1 < value2;
    }

    public static boolean min(long value1, long value2) {
        return value1 < value2;
    }

    public static boolean min(float value1, float value2) {
        return value1 < value2;
    }

    public static boolean min(double value1, double value2) {
        return value1 < value2;
    }

    public static byte min(byte[] values) {
        return NumberUtils.min((byte[])values);
    }

    public static short min(short[] values) {
        return NumberUtils.min((short[])values);
    }

    public static int min(int[] values) {
        return NumberUtils.min((int[])values);
    }

    public static long min(long[] values) {
        return NumberUtils.min((long[])values);
    }

    public static float min(float[] values) {
        return NumberUtils.min((float[])values);
    }

    public static double min(double[] values) {
        return NumberUtils.min((double[])values);
    }

    public static byte avg(byte[] values) {
        if (!ArrayUtils.isEmpty((byte[])values)) {
            return (byte)(MathUtils.sum(values) / values.length);
        }
        return 0;
    }

    public static short avg(short[] values) {
        if (!ArrayUtils.isEmpty((short[])values)) {
            return (short)(MathUtils.sum(values) / values.length);
        }
        return 0;
    }

    public static int avg(int[] values) {
        if (!ArrayUtils.isEmpty((int[])values)) {
            return MathUtils.sum(values) / values.length;
        }
        return 0;
    }

    public static long avg(long[] values) {
        if (!ArrayUtils.isEmpty((long[])values)) {
            return MathUtils.sum(values) / (long)values.length;
        }
        return 0L;
    }

    public static float avg(float[] values) {
        if (!ArrayUtils.isEmpty((float[])values)) {
            return MathUtils.sum(values) / (float)values.length;
        }
        return 0.0f;
    }

    public static double avg(double[] values) {
        if (!ArrayUtils.isEmpty((double[])values)) {
            return MathUtils.sum(values) / (double)values.length;
        }
        return 0.0;
    }

    public static Byte avg(Byte[] values) {
        int valuableSize = ArrayTool.getNotNullValuesCount(values);
        if (valuableSize == 0) {
            return Byte.valueOf("0");
        }
        return (byte)(MathUtils.sum(values) / Byte.valueOf((byte)valuableSize));
    }

    public static Short avg(Short[] values) {
        int valuableSize = ArrayTool.getNotNullValuesCount(values);
        if (valuableSize == 0) {
            return Short.valueOf("0");
        }
        return (short)(MathUtils.sum(values) / Short.valueOf((short)valuableSize));
    }

    public static Integer avg(Integer[] values) {
        int valuableSize = ArrayTool.getNotNullValuesCount(values);
        if (valuableSize == 0) {
            return Integer.valueOf("0");
        }
        return MathUtils.sum(values) / Integer.valueOf(valuableSize);
    }

    public static Long avg(Long[] values) {
        int valuableSize = ArrayTool.getNotNullValuesCount(values);
        if (valuableSize == 0) {
            return Long.valueOf("0");
        }
        return MathUtils.sum(values) / Long.valueOf(valuableSize);
    }

    public static Float avg(Float[] values) {
        int valuableSize = ArrayTool.getNotNullValuesCount(values);
        if (valuableSize == 0) {
            return Float.valueOf("0");
        }
        return Float.valueOf(MathUtils.sum(values).floatValue() / Float.valueOf(valuableSize).floatValue());
    }

    public static Double avg(Double[] values) {
        int valuableSize = ArrayTool.getNotNullValuesCount(values);
        if (valuableSize == 0) {
            return Double.valueOf("0");
        }
        return MathUtils.sum(values) / Double.valueOf(valuableSize);
    }

    public static BigInteger avg(BigInteger[] values) {
        int valuableSize = ArrayTool.getNotNullValuesCount(values);
        if (valuableSize == 0) {
            return BigInteger.ZERO;
        }
        return MathUtils.divide(MathUtils.sum(values), BigInteger.valueOf(valuableSize));
    }

    public static BigDecimal avg(BigDecimal[] values) {
        int valuableSize = ArrayTool.getNotNullValuesCount(values);
        if (valuableSize == 0) {
            return BigDecimal.ZERO;
        }
        return MathUtils.divide(MathUtils.sum(values), BigDecimal.valueOf(valuableSize));
    }

    public static byte small(byte[] values, int position) {
        byte result = 0;
        int index = position - 1;
        if (values == null) {
            throw new IllegalArgumentException("The array cannot be null");
        }
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        Arrays.sort(values);
        result = values[index];
        return result;
    }

    public static short small(short[] values, int position) {
        short result = 0;
        int index = position - 1;
        if (values == null) {
            throw new IllegalArgumentException("The array cannot be null");
        }
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        Arrays.sort(values);
        result = values[index];
        return result;
    }

    public static int small(int[] values, int position) {
        int result = 0;
        int index = position - 1;
        if (values == null) {
            throw new IllegalArgumentException("The array cannot be null");
        }
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        Arrays.sort(values);
        result = values[index];
        return result;
    }

    public static long small(long[] values, int position) {
        long result = 0L;
        int index = position - 1;
        if (values == null) {
            throw new IllegalArgumentException("The array cannot be null");
        }
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        Arrays.sort(values);
        result = values[index];
        return result;
    }

    public static float small(float[] values, int position) {
        float result = 0.0f;
        int index = position - 1;
        if (values == null) {
            throw new IllegalArgumentException("The array cannot be null");
        }
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        Arrays.sort(values);
        result = values[index];
        return result;
    }

    public static double small(double[] values, int position) {
        double result = 0.0;
        int index = position - 1;
        if (values == null) {
            throw new IllegalArgumentException("The array cannot be null");
        }
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        Arrays.sort(values);
        result = values[index];
        return result;
    }

    public static Byte small(Byte[] values, int position) {
        Byte result = Byte.valueOf("0");
        int index = position - 1;
        if (values == null) {
            throw new IllegalArgumentException("The array cannot be null");
        }
        values = ArrayTool.removeNulls(values);
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        Arrays.sort((Object[])values);
        result = values[index];
        return result;
    }

    public static Short small(Short[] values, int position) {
        Short result = Short.valueOf("0");
        int index = position - 1;
        if (values == null) {
            throw new IllegalArgumentException("The array cannot be null");
        }
        values = ArrayTool.removeNulls(values);
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        Arrays.sort((Object[])values);
        result = values[index];
        return result;
    }

    public static Integer small(Integer[] values, int position) {
        Integer result = Integer.valueOf("0");
        int index = position - 1;
        if (values == null) {
            throw new IllegalArgumentException("The array cannot be null");
        }
        values = ArrayTool.removeNulls(values);
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        Arrays.sort((Object[])values);
        result = values[index];
        return result;
    }

    public static Long small(Long[] values, int position) {
        Long result = Long.valueOf("0");
        int index = position - 1;
        if (values == null) {
            throw new IllegalArgumentException("The array cannot be null");
        }
        values = ArrayTool.removeNulls(values);
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        Arrays.sort((Object[])values);
        result = values[index];
        return result;
    }

    public static Float small(Float[] values, int position) {
        Float result = Float.valueOf("0");
        int index = position - 1;
        if (values == null) {
            throw new IllegalArgumentException("The array cannot be null");
        }
        values = ArrayTool.removeNulls(values);
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        Arrays.sort((Object[])values);
        result = values[index];
        return result;
    }

    public static Double small(Double[] values, int position) {
        Double result = Double.valueOf("0");
        int index = position - 1;
        if (values == null) {
            throw new IllegalArgumentException("The array cannot be null");
        }
        values = ArrayTool.removeNulls(values);
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        Arrays.sort((Object[])values);
        result = values[index];
        return result;
    }

    public static BigInteger small(BigInteger[] values, int position) {
        BigInteger result = BigInteger.ZERO;
        int index = position - 1;
        if (values == null) {
            throw new IllegalArgumentException("The array cannot be null");
        }
        values = ArrayTool.removeNulls(values);
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        Arrays.sort(values);
        result = values[index];
        return result;
    }

    public static BigDecimal small(BigDecimal[] values, int position) {
        BigDecimal result = BigDecimal.ZERO;
        int index = position - 1;
        if (values == null) {
            throw new IllegalArgumentException("The array cannot be null");
        }
        values = ArrayTool.removeNulls(values);
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        Arrays.sort(values);
        result = values[index];
        return result;
    }

    public static byte big(byte[] values, int position) {
        byte result = 0;
        int index = position - 1;
        if (values == null) {
            throw new IllegalArgumentException("The array cannot be null");
        }
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        Arrays.sort(values);
        result = values[values.length - 1 - index];
        return result;
    }

    public static short big(short[] values, int position) {
        short result = 0;
        int index = position - 1;
        if (values == null) {
            throw new IllegalArgumentException("The array cannot be null");
        }
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        Arrays.sort(values);
        result = values[values.length - 1 - index];
        return result;
    }

    public static int big(int[] values, int position) {
        int result = 0;
        int index = position - 1;
        if (values == null) {
            throw new IllegalArgumentException("The array cannot be null");
        }
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        Arrays.sort(values);
        result = values[values.length - 1 - index];
        return result;
    }

    public static long big(long[] values, int position) {
        long result = 0L;
        int index = position - 1;
        if (values == null) {
            throw new IllegalArgumentException("The array cannot be null");
        }
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        Arrays.sort(values);
        result = values[values.length - 1 - index];
        return result;
    }

    public static float big(float[] values, int position) {
        float result = 0.0f;
        int index = position - 1;
        if (values == null) {
            throw new IllegalArgumentException("The array cannot be null");
        }
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        Arrays.sort(values);
        result = values[values.length - 1 - index];
        return result;
    }

    public static double big(double[] values, int position) {
        double result = 0.0;
        int index = position - 1;
        if (values == null) {
            throw new IllegalArgumentException("The array cannot be null");
        }
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        Arrays.sort(values);
        result = values[values.length - 1 - index];
        return result;
    }

    public static Byte big(Byte[] values, int position) {
        Byte result = Byte.valueOf("0");
        int index = position - 1;
        if (values == null) {
            throw new IllegalArgumentException("The array cannot be null");
        }
        values = ArrayTool.removeNulls(values);
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        Arrays.sort((Object[])values);
        result = values[values.length - 1 - index];
        return result;
    }

    public static Short big(Short[] values, int position) {
        Short result = Short.valueOf("0");
        int index = position - 1;
        if (values == null) {
            throw new IllegalArgumentException("The array cannot be null");
        }
        values = ArrayTool.removeNulls(values);
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        Arrays.sort((Object[])values);
        result = values[values.length - 1 - index];
        return result;
    }

    public static Integer big(Integer[] values, int position) {
        Integer result = Integer.valueOf("0");
        int index = position - 1;
        if (values == null) {
            throw new IllegalArgumentException("The array cannot be null");
        }
        values = ArrayTool.removeNulls(values);
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        Arrays.sort((Object[])values);
        result = values[values.length - 1 - index];
        return result;
    }

    public static Long big(Long[] values, int position) {
        Long result = Long.valueOf("0");
        int index = position - 1;
        if (values == null) {
            throw new IllegalArgumentException("The array cannot be null");
        }
        values = ArrayTool.removeNulls(values);
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        Arrays.sort((Object[])values);
        result = values[values.length - 1 - index];
        return result;
    }

    public static Float big(Float[] values, int position) {
        Float result = Float.valueOf("0");
        int index = position - 1;
        if (values == null) {
            throw new IllegalArgumentException("The array cannot be null");
        }
        values = ArrayTool.removeNulls(values);
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        Arrays.sort((Object[])values);
        result = values[values.length - 1 - index];
        return result;
    }

    public static Double big(Double[] values, int position) {
        Double result = Double.valueOf("0");
        int index = position - 1;
        if (values == null) {
            throw new IllegalArgumentException("The array cannot be null");
        }
        values = ArrayTool.removeNulls(values);
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        Arrays.sort((Object[])values);
        result = values[values.length - 1 - index];
        return result;
    }

    public static BigInteger big(BigInteger[] values, int position) {
        BigInteger result = BigInteger.ZERO;
        int index = position - 1;
        if (values == null) {
            throw new IllegalArgumentException("The array cannot be null");
        }
        values = ArrayTool.removeNulls(values);
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        Arrays.sort(values);
        result = values[values.length - 1 - index];
        return result;
    }

    public static BigDecimal big(BigDecimal[] values, int position) {
        BigDecimal result = BigDecimal.ZERO;
        int index = position - 1;
        if (values == null) {
            throw new IllegalArgumentException("The array cannot be null");
        }
        values = ArrayTool.removeNulls(values);
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        Arrays.sort(values);
        result = values[values.length - 1 - index];
        return result;
    }

    public static byte sum(byte[] values) {
        return (byte)MathUtils.sum(MathUtils.byteArrayToDouble(values));
    }

    public static short sum(short[] values) {
        return (short)MathUtils.sum(MathUtils.shortArrayToDouble(values));
    }

    public static int sum(int[] values) {
        return (int)MathUtils.sum(MathUtils.intArrayToDouble(values));
    }

    public static long sum(long[] values) {
        return (long)MathUtils.sum(MathUtils.longArrayToDouble(values));
    }

    public static float sum(float[] values) {
        return (float)MathUtils.sum(MathUtils.floatArrayToDouble(values));
    }

    public static Byte sum(Byte[] values) {
        byte sum = Byte.valueOf("0");
        for (Byte value : values) {
            if (value == null) continue;
            sum = (byte)(sum + value);
        }
        return sum;
    }

    public static Short sum(Short[] values) {
        short sum = Short.valueOf("0");
        for (Short value : values) {
            if (value == null) continue;
            sum = (short)(sum + value);
        }
        return sum;
    }

    public static Integer sum(Integer[] values) {
        int sum = Integer.valueOf("0");
        for (Integer value : values) {
            if (value == null) continue;
            sum += value.intValue();
        }
        return sum;
    }

    public static Long sum(Long[] values) {
        long sum = Long.valueOf("0");
        for (Long value : values) {
            if (value == null) continue;
            sum += value.longValue();
        }
        return sum;
    }

    public static Float sum(Float[] values) {
        float sum = Float.valueOf("0").floatValue();
        for (Float value : values) {
            if (value == null) continue;
            sum += value.floatValue();
        }
        return Float.valueOf(sum);
    }

    public static Double sum(Double[] values) {
        double sum = Double.valueOf("0");
        for (Double value : values) {
            if (value == null) continue;
            sum += value.doubleValue();
        }
        return sum;
    }

    public static BigInteger sum(BigInteger[] values) {
        BigInteger sum = BigInteger.ZERO;
        for (BigInteger value : values) {
            if (value == null) continue;
            sum = sum.add(value);
        }
        return sum;
    }

    public static BigDecimal sum(BigDecimal[] values) {
        BigDecimal sum = BigDecimal.ZERO;
        for (BigDecimal value : values) {
            if (value == null) continue;
            sum = sum.add(value);
        }
        return sum;
    }

    public static byte median(byte[] values) {
        double[] doubleArray = MathUtils.byteArrayToDouble(values);
        Median median = new Median();
        return (byte)median.evaluate(doubleArray, 0, doubleArray.length);
    }

    public static short median(short[] values) {
        double[] doubleArray = MathUtils.shortArrayToDouble(values);
        Median median = new Median();
        return (short)median.evaluate(doubleArray, 0, doubleArray.length);
    }

    public static int median(int[] values) {
        double[] doubleArray = MathUtils.intArrayToDouble(values);
        Median median = new Median();
        return (int)median.evaluate(doubleArray, 0, doubleArray.length);
    }

    public static long median(long[] values) {
        double[] doubleArray = MathUtils.longArrayToDouble(values);
        Median median = new Median();
        return (long)median.evaluate(doubleArray, 0, doubleArray.length);
    }

    public static float median(float[] values) {
        double[] doubleArray = MathUtils.floatArrayToDouble(values);
        Median median = new Median();
        return (float)median.evaluate(doubleArray, 0, doubleArray.length);
    }

    public static Byte median(Byte[] values) {
        throw new NotImplementedException(String.format("Method median for %s is not implemented yet", values.getClass().getName()));
    }

    public static Short median(Short[] values) {
        throw new NotImplementedException(String.format("Method median for %s is not implemented yet", values.getClass().getName()));
    }

    public static Integer median(Integer[] values) {
        throw new NotImplementedException(String.format("Method median for %s is not implemented yet", values.getClass().getName()));
    }

    public static Long median(Long[] values) {
        throw new NotImplementedException(String.format("Method median for %s is not implemented yet", values.getClass().getName()));
    }

    public static Float median(Float[] values) {
        throw new NotImplementedException(String.format("Method median for %s is not implemented yet", values.getClass().getName()));
    }

    public static Double median(Double[] values) {
        throw new NotImplementedException(String.format("Method median for %s is not implemented yet", values.getClass().getName()));
    }

    public static BigInteger median(BigInteger[] values) {
        throw new NotImplementedException(String.format("Method median for %s is not implemented yet", values.getClass().getName()));
    }

    public static BigDecimal median(BigDecimal[] values) {
        throw new NotImplementedException(String.format("Method median for %s is not implemented yet", values.getClass().getName()));
    }

    public static double product(byte[] values) {
        return MathUtils.product(MathUtils.byteArrayToDouble(values));
    }

    public static double product(short[] values) {
        return MathUtils.product(MathUtils.shortArrayToDouble(values));
    }

    public static double product(int[] values) {
        return MathUtils.product(MathUtils.intArrayToDouble(values));
    }

    public static double product(long[] values) {
        return MathUtils.product(MathUtils.longArrayToDouble(values));
    }

    public static double product(float[] values) {
        return MathUtils.product(MathUtils.floatArrayToDouble(values));
    }

    private static double[] byteArrayToDouble(byte[] values) {
        double[] doubleArray = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            doubleArray[i] = values[i];
        }
        return doubleArray;
    }

    private static double[] shortArrayToDouble(short[] values) {
        double[] doubleArray = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            doubleArray[i] = values[i];
        }
        return doubleArray;
    }

    private static double[] intArrayToDouble(int[] values) {
        double[] doubleArray = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            doubleArray[i] = values[i];
        }
        return doubleArray;
    }

    private static double[] longArrayToDouble(long[] values) {
        double[] doubleArray = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            doubleArray[i] = values[i];
        }
        return doubleArray;
    }

    private static double[] floatArrayToDouble(float[] values) {
        double[] doubleArray = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            doubleArray[i] = values[i];
        }
        return doubleArray;
    }

    public static double product(Byte[] values) {
        boolean hasValues = false;
        double res = 1.0;
        for (Byte value : values) {
            if (value == null) continue;
            res *= (double)value.byteValue();
            hasValues = true;
        }
        return hasValues ? res : 0.0;
    }

    public static double product(Short[] values) {
        boolean hasValues = false;
        double res = 1.0;
        for (Short value : values) {
            if (value == null) continue;
            res *= (double)value.shortValue();
            hasValues = true;
        }
        return hasValues ? res : 0.0;
    }

    public static double product(Integer[] values) {
        boolean hasValues = false;
        double res = 1.0;
        for (Integer value : values) {
            if (value == null) continue;
            res *= (double)value.intValue();
            hasValues = true;
        }
        return hasValues ? res : 0.0;
    }

    public static double product(Long[] values) {
        boolean hasValues = false;
        double res = 1.0;
        for (Long value : values) {
            if (value == null) continue;
            res *= (double)value.longValue();
            hasValues = true;
        }
        return hasValues ? res : 0.0;
    }

    public static double product(Float[] values) {
        boolean hasValues = false;
        double res = 1.0;
        for (Float value : values) {
            if (value == null) continue;
            res *= (double)value.floatValue();
            hasValues = true;
        }
        return hasValues ? res : 0.0;
    }

    public static double product(Double[] values) {
        boolean hasValues = false;
        double res = 1.0;
        for (Double value : values) {
            if (value == null) continue;
            res *= value.doubleValue();
            hasValues = true;
        }
        return hasValues ? res : 0.0;
    }

    public static BigInteger product(BigInteger[] values) {
        boolean hasValues = false;
        BigInteger res = BigInteger.ONE;
        for (BigInteger value : values) {
            if (value == null) continue;
            res = res.multiply(value);
            hasValues = true;
        }
        return hasValues ? res : BigInteger.ZERO;
    }

    public static BigDecimal product(BigDecimal[] values) {
        boolean hasValues = false;
        BigDecimal res = BigDecimal.ONE;
        for (BigDecimal value : values) {
            if (value == null) continue;
            res = res.multiply(value);
            hasValues = true;
        }
        return hasValues ? res : BigDecimal.ZERO;
    }

    public static byte[] slice(byte[] values, int startIndexInclusive) {
        if (values != null) {
            return MathUtils.slice(values, startIndexInclusive, values.length);
        }
        return null;
    }

    public static byte[] slice(byte[] values, int startIndexInclusive, int endIndexExclusive) {
        if (values != null) {
            return ArrayUtils.subarray((byte[])values, (int)startIndexInclusive, (int)endIndexExclusive);
        }
        return null;
    }

    public static short[] slice(short[] values, int startIndexInclusive) {
        if (values != null) {
            return MathUtils.slice(values, startIndexInclusive, values.length);
        }
        return null;
    }

    public static short[] slice(short[] values, int startIndexInclusive, int endIndexExclusive) {
        if (values != null) {
            return ArrayUtils.subarray((short[])values, (int)startIndexInclusive, (int)endIndexExclusive);
        }
        return null;
    }

    public static int[] slice(int[] values, int startIndexInclusive) {
        if (values != null) {
            return MathUtils.slice(values, startIndexInclusive, values.length);
        }
        return null;
    }

    public static int[] slice(int[] values, int startIndexInclusive, int endIndexExclusive) {
        if (values != null) {
            return ArrayUtils.subarray((int[])values, (int)startIndexInclusive, (int)endIndexExclusive);
        }
        return null;
    }

    public static long[] slice(long[] values, int startIndexInclusive) {
        if (values != null) {
            return MathUtils.slice(values, startIndexInclusive, values.length);
        }
        return null;
    }

    public static long[] slice(long[] values, int startIndexInclusive, int endIndexExclusive) {
        if (values != null) {
            return ArrayUtils.subarray((long[])values, (int)startIndexInclusive, (int)endIndexExclusive);
        }
        return null;
    }

    public static float[] slice(float[] values, int startIndexInclusive) {
        if (values != null) {
            return MathUtils.slice(values, startIndexInclusive, values.length);
        }
        return null;
    }

    public static float[] slice(float[] values, int startIndexInclusive, int endIndexExclusive) {
        if (values != null) {
            return ArrayUtils.subarray((float[])values, (int)startIndexInclusive, (int)endIndexExclusive);
        }
        return null;
    }

    public static double[] slice(double[] values, int startIndexInclusive) {
        if (values != null) {
            return MathUtils.slice(values, startIndexInclusive, values.length);
        }
        return null;
    }

    public static double[] slice(double[] values, int startIndexInclusive, int endIndexExclusive) {
        if (values != null) {
            return ArrayUtils.subarray((double[])values, (int)startIndexInclusive, (int)endIndexExclusive);
        }
        return null;
    }

    public static Byte[] slice(Byte[] values, int startIndexInclusive) {
        if (values != null) {
            return MathUtils.slice(values, startIndexInclusive, values.length);
        }
        return null;
    }

    public static Byte[] slice(Byte[] values, int startIndexInclusive, int endIndexExclusive) {
        if (values != null) {
            return (Byte[])ArrayUtils.subarray((Object[])values, (int)startIndexInclusive, (int)endIndexExclusive);
        }
        return null;
    }

    public static Short[] slice(Short[] values, int startIndexInclusive) {
        if (values != null) {
            return MathUtils.slice(values, startIndexInclusive, values.length);
        }
        return null;
    }

    public static Short[] slice(Short[] values, int startIndexInclusive, int endIndexExclusive) {
        if (values != null) {
            return (Short[])ArrayUtils.subarray((Object[])values, (int)startIndexInclusive, (int)endIndexExclusive);
        }
        return null;
    }

    public static Integer[] slice(Integer[] values, int startIndexInclusive) {
        if (values != null) {
            return MathUtils.slice(values, startIndexInclusive, values.length);
        }
        return null;
    }

    public static Integer[] slice(Integer[] values, int startIndexInclusive, int endIndexExclusive) {
        if (values != null) {
            return (Integer[])ArrayUtils.subarray((Object[])values, (int)startIndexInclusive, (int)endIndexExclusive);
        }
        return null;
    }

    public static Long[] slice(Long[] values, int startIndexInclusive) {
        if (values != null) {
            return MathUtils.slice(values, startIndexInclusive, values.length);
        }
        return null;
    }

    public static Long[] slice(Long[] values, int startIndexInclusive, int endIndexExclusive) {
        if (values != null) {
            return (Long[])ArrayUtils.subarray((Object[])values, (int)startIndexInclusive, (int)endIndexExclusive);
        }
        return null;
    }

    public static Float[] slice(Float[] values, int startIndexInclusive) {
        if (values != null) {
            return MathUtils.slice(values, startIndexInclusive, values.length);
        }
        return null;
    }

    public static Float[] slice(Float[] values, int startIndexInclusive, int endIndexExclusive) {
        if (values != null) {
            return (Float[])ArrayUtils.subarray((Object[])values, (int)startIndexInclusive, (int)endIndexExclusive);
        }
        return null;
    }

    public static Double[] slice(Double[] values, int startIndexInclusive) {
        if (values != null) {
            return MathUtils.slice(values, startIndexInclusive, values.length);
        }
        return null;
    }

    public static Double[] slice(Double[] values, int startIndexInclusive, int endIndexExclusive) {
        if (values != null) {
            return (Double[])ArrayUtils.subarray((Object[])values, (int)startIndexInclusive, (int)endIndexExclusive);
        }
        return null;
    }

    public static BigInteger[] slice(BigInteger[] values, int startIndexInclusive) {
        if (values != null) {
            return MathUtils.slice(values, startIndexInclusive, values.length);
        }
        return null;
    }

    public static BigInteger[] slice(BigInteger[] values, int startIndexInclusive, int endIndexExclusive) {
        if (values != null) {
            return (BigInteger[])ArrayUtils.subarray((Object[])values, (int)startIndexInclusive, (int)endIndexExclusive);
        }
        return null;
    }

    public static BigDecimal[] slice(BigDecimal[] values, int startIndexInclusive) {
        if (values != null) {
            return MathUtils.slice(values, startIndexInclusive, values.length);
        }
        return null;
    }

    public static BigDecimal[] slice(BigDecimal[] values, int startIndexInclusive, int endIndexExclusive) {
        if (values != null) {
            return (BigDecimal[])ArrayUtils.subarray((Object[])values, (int)startIndexInclusive, (int)endIndexExclusive);
        }
        return null;
    }

    public static byte mod(byte number, byte divisor) {
        long quotient = MathUtils.quotient(number, divisor);
        byte intPart = (byte)quotient;
        if (quotient < 0L) {
            intPart = (byte)(intPart - 1);
        }
        return (byte)(number - intPart * divisor);
    }

    public static short mod(short number, short divisor) {
        long quotient = MathUtils.quotient(number, divisor);
        short intPart = (short)quotient;
        if (quotient < 0L) {
            intPart = (short)(intPart - 1);
        }
        return (short)(number - intPart * divisor);
    }

    public static int mod(int number, int divisor) {
        long quotient = MathUtils.quotient(number, divisor);
        int intPart = (int)quotient;
        if (quotient < 0L) {
            --intPart;
        }
        return number - intPart * divisor;
    }

    public static long mod(long number, long divisor) {
        long quotient;
        long intPart = quotient = MathUtils.quotient(number, divisor);
        if (quotient < 0L) {
            --intPart;
        }
        return number - intPart * divisor;
    }

    public static float mod(float number, float divisor) {
        long quotient = MathUtils.quotient(number, divisor);
        float intPart = quotient;
        if (quotient < 0L) {
            intPart -= 1.0f;
        }
        return number - intPart * divisor;
    }

    public static double mod(double number, double divisor) {
        long quotient = MathUtils.quotient(number, divisor);
        double intPart = quotient;
        if (quotient < 0L) {
            intPart -= 1.0;
        }
        return number - intPart * divisor;
    }

    public static Byte mod(Byte number, Byte divisor) {
        if (number == null || divisor == null) {
            return Byte.valueOf("0");
        }
        return MathUtils.mod((byte)number, (byte)divisor);
    }

    public static Short mod(Short number, Short divisor) {
        if (number == null || divisor == null) {
            return Short.valueOf("0");
        }
        return MathUtils.mod((short)number, (short)divisor);
    }

    public static Integer mod(Integer number, Integer divisor) {
        if (number == null || divisor == null) {
            return Integer.valueOf("0");
        }
        return MathUtils.mod((int)number, (int)divisor);
    }

    public static Long mod(Long number, Long divisor) {
        if (number == null || divisor == null) {
            return Long.valueOf("0");
        }
        return MathUtils.mod((long)number, (long)divisor);
    }

    public static Float mod(Float number, Float divisor) {
        if (number == null || divisor == null) {
            return Float.valueOf("0");
        }
        return Float.valueOf(MathUtils.mod(number.floatValue(), divisor.floatValue()));
    }

    public static Double mod(Double number, Double divisor) {
        if (number == null || divisor == null) {
            return Double.valueOf("0");
        }
        return MathUtils.mod((double)number, (double)divisor);
    }

    public static BigInteger mod(BigInteger number, BigInteger divisor) {
        long quotient;
        if (number == null || divisor == null) {
            return BigInteger.ZERO;
        }
        long intPart = quotient = MathUtils.quotient(number, divisor);
        if (quotient < 0L) {
            --intPart;
        }
        return number.subtract(BigInteger.valueOf(intPart).multiply(divisor));
    }

    public static BigDecimal mod(BigDecimal number, BigDecimal divisor) {
        long quotient;
        if (number == null || divisor == null) {
            return BigDecimal.ZERO;
        }
        long intPart = quotient = MathUtils.quotient(number, divisor);
        if (quotient < 0L) {
            --intPart;
        }
        return number.subtract(BigDecimal.valueOf(intPart).multiply(divisor));
    }

    public static long quotient(byte number, byte divisor) {
        return number / divisor;
    }

    public static long quotient(short number, short divisor) {
        return number / divisor;
    }

    public static long quotient(int number, int divisor) {
        return number / divisor;
    }

    public static long quotient(long number, long divisor) {
        return number / divisor;
    }

    public static long quotient(float number, float divisor) {
        return (long)(number / divisor);
    }

    public static long quotient(double number, double divisor) {
        return (long)(number / divisor);
    }

    public static long quotient(Byte number, Byte divisor) {
        if (number == null || divisor == null) {
            return 0L;
        }
        return MathUtils.quotient((byte)number, (byte)divisor);
    }

    public static long quotient(Short number, Short divisor) {
        if (number == null || divisor == null) {
            return 0L;
        }
        return MathUtils.quotient((short)number, (short)divisor);
    }

    public static long quotient(Integer number, Integer divisor) {
        if (number == null || divisor == null) {
            return 0L;
        }
        return MathUtils.quotient((int)number, (int)divisor);
    }

    public static long quotient(Long number, Long divisor) {
        if (number == null || divisor == null) {
            return 0L;
        }
        return MathUtils.quotient((long)number, (long)divisor);
    }

    public static long quotient(Float number, Float divisor) {
        if (number == null || divisor == null) {
            return 0L;
        }
        return MathUtils.quotient(number.floatValue(), divisor.floatValue());
    }

    public static long quotient(Double number, Double divisor) {
        if (number == null || divisor == null) {
            return 0L;
        }
        return MathUtils.quotient((double)number, (double)divisor);
    }

    public static long quotient(BigInteger number, BigInteger divisor) {
        if (number == null || divisor == null) {
            return 0L;
        }
        return MathUtils.divide(number, divisor).longValue();
    }

    public static long quotient(BigDecimal number, BigDecimal divisor) {
        if (number == null || divisor == null) {
            return 0L;
        }
        return MathUtils.divide(number, divisor).longValue();
    }

    public static byte[] sort(byte[] values) {
        Arrays.sort(values);
        return values;
    }

    public static short[] sort(short[] values) {
        Arrays.sort(values);
        return values;
    }

    public static int[] sort(int[] values) {
        Arrays.sort(values);
        return values;
    }

    public static long[] sort(long[] values) {
        Arrays.sort(values);
        return values;
    }

    public static float[] sort(float[] values) {
        Arrays.sort(values);
        return values;
    }

    public static double[] sort(double[] values) {
        Arrays.sort(values);
        return values;
    }

    public static Byte[] sort(Byte[] values) {
        values = ArrayTool.removeNulls(values);
        Arrays.sort((Object[])values);
        return values;
    }

    public static Short[] sort(Short[] values) {
        values = ArrayTool.removeNulls(values);
        Arrays.sort((Object[])values);
        return values;
    }

    public static Integer[] sort(Integer[] values) {
        values = ArrayTool.removeNulls(values);
        Arrays.sort((Object[])values);
        return values;
    }

    public static Long[] sort(Long[] values) {
        values = ArrayTool.removeNulls(values);
        Arrays.sort((Object[])values);
        return values;
    }

    public static Float[] sort(Float[] values) {
        values = ArrayTool.removeNulls(values);
        Arrays.sort((Object[])values);
        return values;
    }

    public static Double[] sort(Double[] values) {
        values = ArrayTool.removeNulls(values);
        Arrays.sort((Object[])values);
        return values;
    }

    public static BigInteger[] sort(BigInteger[] values) {
        values = ArrayTool.removeNulls(values);
        Arrays.sort(values);
        return values;
    }

    public static BigDecimal[] sort(BigDecimal[] values) {
        values = ArrayTool.removeNulls(values);
        Arrays.sort(values);
        return values;
    }

    public static boolean eq(float x, float y) {
        if (Float.compare(x, y) == 0) {
            return true;
        }
        if (Float.isInfinite(x) || Float.isInfinite(y) || Float.isNaN(x) || Float.isNaN(y)) {
            return false;
        }
        return Math.abs(x - y) <= Math.ulp(x);
    }

    public static boolean ne(float x, float y) {
        return !MathUtils.eq(x, y);
    }

    public static boolean gt(float x, float y) {
        if (Float.POSITIVE_INFINITY == x && Float.POSITIVE_INFINITY != y && !Float.isNaN(y)) {
            return true;
        }
        return Math.abs(x - y) > Math.ulp(x) && x > y;
    }

    public static boolean ge(float x, float y) {
        return MathUtils.eq(x, y) || MathUtils.gt(x, y);
    }

    public static boolean lt(float x, float y) {
        if (Float.NEGATIVE_INFINITY == x && Float.NEGATIVE_INFINITY != y && !Float.isNaN(y)) {
            return true;
        }
        return Math.abs(x - y) > Math.ulp(x) && x < y;
    }

    public static boolean le(float x, float y) {
        return MathUtils.eq(x, y) || MathUtils.lt(x, y);
    }

    public static boolean eq(double x, double y) {
        if (Double.compare(x, y) == 0) {
            return true;
        }
        if (Double.isInfinite(x) || Double.isInfinite(y) || Double.isNaN(x) || Double.isNaN(y)) {
            return false;
        }
        return Math.abs(x - y) <= Math.ulp(x);
    }

    public static boolean ne(double x, double y) {
        return !MathUtils.eq(x, y);
    }

    public static boolean gt(double x, double y) {
        if (Double.POSITIVE_INFINITY == x && Double.POSITIVE_INFINITY != y && !Double.isNaN(y)) {
            return true;
        }
        return Math.abs(x - y) > Math.ulp(x) && x > y;
    }

    public static boolean ge(double x, double y) {
        return MathUtils.eq(x, y) || MathUtils.gt(x, y);
    }

    public static boolean lt(double x, double y) {
        if (Double.NEGATIVE_INFINITY == x && Double.NEGATIVE_INFINITY != y && !Double.isNaN(y)) {
            return true;
        }
        return Math.abs(x - y) > Math.ulp(x) && x < y;
    }

    public static boolean le(double x, double y) {
        return MathUtils.eq(x, y) || MathUtils.lt(x, y);
    }

    public static boolean eq(BigDecimal x, BigDecimal y) {
        return x.subtract(y).abs().compareTo(x.ulp()) <= 0;
    }

    public static BigDecimal divide(BigDecimal number, BigDecimal divisor) {
        if (number == null || divisor == null) {
            return null;
        }
        return number.divide(divisor, 5, RoundingMode.HALF_UP);
    }

    public static BigInteger divide(BigInteger number, BigInteger divisor) {
        if (number == null || divisor == null) {
            return null;
        }
        return number.divide(divisor);
    }

    public static boolean max(BigInteger value1, BigInteger value2) {
        return value1.compareTo(value2) > 0;
    }

    public static boolean max(BigDecimal value1, BigDecimal value2) {
        return value1.compareTo(value2) > 0;
    }

    public static char max(char[] values) {
        char max = '\u0000';
        for (char value : values) {
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    public static BigInteger max(BigInteger[] values) {
        return (BigInteger)MathUtils.max((Object[])values);
    }

    public static BigDecimal max(BigDecimal[] values) {
        return (BigDecimal)MathUtils.max((Object[])values);
    }

    public static Object max(Object[] values) {
        if (values == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if ((values = ArrayTool.removeNulls(values)).length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        if (!ClassUtils.isAssignable(values.getClass().getComponentType(), Number.class, (boolean)true) || !ClassUtils.isAssignable(values.getClass().getComponentType(), Comparable.class, (boolean)true)) {
            throw new IllegalArgumentException("Income array must be comparable numeric.");
        }
        Comparable[] numberArray = (Comparable[])values;
        Number max = (Number)((Object)numberArray[0]);
        for (int i = 1; i < numberArray.length; ++i) {
            if (numberArray[i].compareTo(max) <= 0) continue;
            max = (Number)((Object)numberArray[i]);
        }
        return max;
    }

    public static boolean min(BigInteger value1, BigInteger value2) {
        return value1.compareTo(value2) < 0;
    }

    public static boolean min(BigDecimal value1, BigDecimal value2) {
        return value1.compareTo(value2) < 0;
    }

    public static char min(char[] values) {
        char min = values[0];
        for (int i = 1; i < values.length; ++i) {
            if (values[i] >= min) continue;
            min = values[i];
        }
        return min;
    }

    public static BigInteger min(BigInteger[] values) {
        return (BigInteger)MathUtils.min((Object[])values);
    }

    public static BigDecimal min(BigDecimal[] values) {
        return (BigDecimal)MathUtils.min((Object[])values);
    }

    public static Object min(Object[] values) {
        if (values == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if ((values = ArrayTool.removeNulls(values)).length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        if (!ClassUtils.isAssignable(values.getClass().getComponentType(), Number.class, (boolean)true) || !ClassUtils.isAssignable(values.getClass().getComponentType(), Comparable.class, (boolean)true)) {
            throw new IllegalArgumentException("Income array must be comparable numeric.");
        }
        Comparable[] numberArray = (Comparable[])values;
        Number min = (Number)((Object)numberArray[0]);
        for (int i = 1; i < numberArray.length; ++i) {
            if (numberArray[i].compareTo(min) >= 0) continue;
            min = (Number)((Object)numberArray[i]);
        }
        return min;
    }

    public static double sum(double[] values) {
        return StatUtils.sum((double[])values);
    }

    public static double median(double[] values) {
        Median median = new Median();
        return median.evaluate(values, 0, values.length);
    }

    public static double product(double[] values) {
        return StatUtils.product((double[])values);
    }
}

