/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.generation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.util.generation.CharInitializationWriter;
import org.openl.util.generation.CommonInitializationWriter;
import org.openl.util.generation.JavaClassGeneratorHelper;
import org.openl.util.generation.JavaGenerator;
import org.openl.util.generation.NumberInitializationWriter;
import org.openl.util.generation.StringInitializationWriter;
import org.openl.util.generation.TypeInitializationWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleBeanJavaGenerator
extends JavaGenerator {
    private final Log log = LogFactory.getLog(SimpleBeanJavaGenerator.class);
    private Map<String, Class<?>> datatypeDeclaredFields;
    private Map<String, Class<?>> datatypeAllFields;
    private static Map<Class<?>, TypeInitializationWriter> initializationWriters = new HashMap();

    public SimpleBeanJavaGenerator(Class<?> datatypeClass, Map<String, Class<?>> declaredFields, Map<String, Class<?>> allFields) {
        super(datatypeClass);
        this.datatypeDeclaredFields = new LinkedHashMap(declaredFields);
        this.datatypeAllFields = new LinkedHashMap(allFields);
    }

    @Override
    public String generateJavaClass() {
        StringBuffer buf = new StringBuffer(10000);
        this.addComment(buf);
        this.addPackage(buf);
        this.addImports(buf);
        this.addClassDeclaration(buf, ClassUtils.getShortClassName((String)this.getClassNameForGeneration()), ClassUtils.getShortClassName(this.getClassForGeneration().getSuperclass()));
        this.addFieldsDeclaration(buf);
        this.addConstructors(buf);
        this.addMethods(buf);
        buf.append("\n}");
        return buf.toString();
    }

    private void addMethods(StringBuffer buf) {
        Method[] methods = this.getClassForGeneration().getDeclaredMethods();
        Arrays.sort(methods, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        for (Method method : methods) {
            if (method.getName().startsWith("get")) {
                this.addGetter(buf, method, this.datatypeAllFields.keySet());
                continue;
            }
            if (method.getName().startsWith("set")) {
                this.addSetter(buf, method, this.datatypeAllFields.keySet());
                continue;
            }
            if (method.getName().equals("equals")) {
                buf.append(JavaClassGeneratorHelper.getEqualsMethod(this.getClassForGeneration().getSimpleName(), this.datatypeAllFields.keySet()));
                continue;
            }
            if (method.getName().startsWith("hashCode")) {
                buf.append(JavaClassGeneratorHelper.getHashCodeMethod(this.datatypeAllFields.keySet()));
                continue;
            }
            if (!method.getName().equals("toString")) continue;
            buf.append(JavaClassGeneratorHelper.getToStringMethod(this.getClassForGeneration().getSimpleName(), this.datatypeAllFields));
        }
    }

    private void addConstructors(StringBuffer buf) {
        buf.append(JavaClassGeneratorHelper.getDefaultConstructor(this.getClassForGeneration().getSimpleName()));
        LinkedHashMap fieldsForConstructor = new LinkedHashMap();
        int numberOfParamsForSuperConstructor = 0;
        if (!this.getClassForGeneration().getSuperclass().equals(Object.class)) {
            numberOfParamsForSuperConstructor = this.datatypeAllFields.size() - this.datatypeDeclaredFields.size();
            Constructor<?> superConstructorWithFields = JavaClassGeneratorHelper.getBeanConstructorWithAllFields(this.getClassForGeneration().getSuperclass(), numberOfParamsForSuperConstructor);
            if (superConstructorWithFields != null) {
                int i = 0;
                for (Map.Entry<String, Class<?>> field : this.datatypeAllFields.entrySet()) {
                    if (field.getValue() != superConstructorWithFields.getParameterTypes()[i]) {
                        fieldsForConstructor.clear();
                        numberOfParamsForSuperConstructor = 0;
                    } else {
                        fieldsForConstructor.put(field.getKey(), field.getValue());
                        if (++i != numberOfParamsForSuperConstructor) continue;
                    }
                    break;
                }
            } else {
                numberOfParamsForSuperConstructor = 0;
            }
        }
        fieldsForConstructor.putAll(this.datatypeDeclaredFields);
        buf.append(JavaClassGeneratorHelper.getConstructorWithFields(this.getClassForGeneration().getSimpleName(), fieldsForConstructor, numberOfParamsForSuperConstructor));
    }

    private void addFieldsDeclaration(StringBuffer buf) {
        Object datatypeInstance = null;
        try {
            datatypeInstance = this.getClassForGeneration().newInstance();
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
        Field[] fields = this.getClassForGeneration().getDeclaredFields();
        Arrays.sort(fields, new Comparator<Field>(){

            @Override
            public int compare(Field o1, Field o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        for (Field field : fields) {
            Class<?> fieldType = field.getType();
            Object fieldValue = this.getFieldValue(datatypeInstance, field.getName());
            if (fieldValue != null) {
                TypeInitializationWriter writer = this.getFieldValueWriter(fieldType);
                if (writer == null) {
                    String errorMessage = String.format("Can`t write value for %s field of type %s", fieldValue, fieldType.getName());
                    this.log.error((Object)errorMessage);
                    continue;
                }
                String valueInitialzation = writer.getInitialization(fieldValue);
                buf.append(JavaClassGeneratorHelper.getProtectedFieldInitialzation(JavaClassGeneratorHelper.filterTypeName(fieldType), field.getName(), valueInitialzation));
                continue;
            }
            buf.append(JavaClassGeneratorHelper.getProtectedFieldDeclaration(JavaClassGeneratorHelper.filterTypeName(fieldType), field.getName()));
        }
        buf.append("\n");
    }

    private TypeInitializationWriter getFieldValueWriter(Class<?> fieldValueClass) {
        TypeInitializationWriter writer = initializationWriters.get(fieldValueClass);
        if (writer == null && ClassUtils.isAssignable(fieldValueClass, Number.class)) {
            writer = initializationWriters.get(Number.class);
        }
        return writer;
    }

    private Object getFieldValue(Object datatypeInstance, String fieldName) {
        Object fieldValue = null;
        try {
            Field field = this.getClassForGeneration().getDeclaredField(fieldName);
            field.setAccessible(true);
            fieldValue = field.get(datatypeInstance);
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
        return fieldValue;
    }

    static {
        initializationWriters.put(Byte.TYPE, new CommonInitializationWriter());
        initializationWriters.put(Short.TYPE, new CommonInitializationWriter());
        initializationWriters.put(Integer.TYPE, new CommonInitializationWriter());
        initializationWriters.put(Long.TYPE, new CommonInitializationWriter());
        initializationWriters.put(Float.TYPE, new CommonInitializationWriter());
        initializationWriters.put(Double.TYPE, new CommonInitializationWriter());
        initializationWriters.put(Boolean.TYPE, new CommonInitializationWriter());
        initializationWriters.put(Byte.class, new CommonInitializationWriter());
        initializationWriters.put(Short.class, new CommonInitializationWriter());
        initializationWriters.put(Integer.class, new CommonInitializationWriter());
        initializationWriters.put(Long.class, new CommonInitializationWriter());
        initializationWriters.put(Float.class, new CommonInitializationWriter());
        initializationWriters.put(Double.class, new CommonInitializationWriter());
        initializationWriters.put(Boolean.class, new CommonInitializationWriter());
        initializationWriters.put(Number.class, new NumberInitializationWriter());
        initializationWriters.put(String.class, new StringInitializationWriter());
        initializationWriters.put(Character.TYPE, new CharInitializationWriter());
        initializationWriters.put(Character.class, new CharInitializationWriter());
    }
}

