/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.generation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.openl.util.generation.JavaClassGeneratorHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaGenerator {
    public static final String SET = "set";
    public static final String GET = "get";
    public static final String TO_STRING = "toString";
    public static final String HASH_CODE = "hashCode";
    public static final String EQUALS = "equals";
    private Class<?> classForGeneration;

    public abstract String generateJavaClass();

    public JavaGenerator(Class<?> classForGeneration) {
        this.classForGeneration = classForGeneration;
    }

    public Class<?> getClassForGeneration() {
        return this.classForGeneration;
    }

    public String getClassNameForGeneration() {
        return this.classForGeneration.getName();
    }

    public void addComment(StringBuffer buf) {
        buf.append(JavaClassGeneratorHelper.getCommentText("This class has been generated. Do not change it."));
    }

    public void addPackage(StringBuffer buf) {
        buf.append(JavaClassGeneratorHelper.getPackageText(ClassUtils.getPackageName(this.classForGeneration)));
    }

    public void addImports(StringBuffer buf) {
        for (String importStr : this.gatherImports()) {
            this.addImport(buf, importStr);
        }
    }

    public void addImport(StringBuffer buf, String importStr) {
        buf.append(JavaClassGeneratorHelper.getImportText(importStr));
    }

    public Set<String> gatherImports() {
        HashSet<String> importsSet = new HashSet<String>();
        for (Method method : this.classForGeneration.getDeclaredMethods()) {
            Class<?> methodReturnType;
            if (!(!method.getName().startsWith(GET) || (methodReturnType = method.getReturnType()).isPrimitive() || methodReturnType.isArray() && methodReturnType.getComponentType().isPrimitive())) {
                importsSet.add(this.filterTypeNameForImport(methodReturnType));
            }
            if (method.getName().equals(EQUALS)) {
                importsSet.add(this.filterTypeNameForImport(EqualsBuilder.class));
            }
            if (method.getName().startsWith(HASH_CODE)) {
                importsSet.add(this.filterTypeNameForImport(HashCodeBuilder.class));
            }
            if (!method.getName().startsWith(TO_STRING)) continue;
            importsSet.add(this.filterTypeNameForImport(ArrayUtils.class));
        }
        for (Executable executable : this.classForGeneration.getDeclaredConstructors()) {
            for (Class<?> paramType : ((Constructor)executable).getParameterTypes()) {
                if (paramType.isPrimitive() || paramType.isArray() && paramType.getComponentType().isPrimitive()) continue;
                importsSet.add(this.filterTypeNameForImport(paramType));
            }
        }
        Class<?> superClass = this.getClassForGeneration().getSuperclass();
        if (superClass != Object.class) {
            importsSet.add(this.filterTypeNameForImport(superClass));
        }
        return importsSet;
    }

    private String filterTypeNameForImport(Class<?> type) {
        String typeName = JavaClassGeneratorHelper.filterTypeName(type);
        int index = typeName.indexOf("[");
        if (index > 0) {
            return typeName.substring(0, index);
        }
        return typeName;
    }

    public void addClassDeclaration(StringBuffer buf, String className, String superClass) {
        buf.append(JavaClassGeneratorHelper.getSimplePublicClassDeclaration(className));
        if (superClass != null && !"Object".equals(superClass)) {
            buf.append(" extends ");
            buf.append(superClass);
        }
        buf.append(JavaClassGeneratorHelper.getOpenBracket());
    }

    public void addGetter(StringBuffer buf, Method method, Set<String> allDatatypeFieldNames) {
        String fieldName = this.getFieldName(method.getName(), allDatatypeFieldNames);
        if (StringUtils.isNotBlank((String)fieldName)) {
            buf.append(JavaClassGeneratorHelper.getPublicGetterMethod(JavaClassGeneratorHelper.filterTypeName(method.getReturnType()), fieldName));
        }
    }

    public void addSetter(StringBuffer buf, Method method, Set<String> allDatatypeFieldNames) {
        String fieldName = this.getFieldName(method.getName(), allDatatypeFieldNames);
        if (StringUtils.isNotBlank((String)fieldName)) {
            buf.append(JavaClassGeneratorHelper.getPublicSetterMethod(JavaClassGeneratorHelper.filterTypeName(method.getParameterTypes()[0]), fieldName));
        }
    }

    public String getFieldName(String methodName, Set<String> allDatatypeFieldNames) {
        if (methodName != null && allDatatypeFieldNames != null) {
            String fieldNameFromMethod = methodName.substring(3);
            for (String datatypeField : allDatatypeFieldNames) {
                if (!fieldNameFromMethod.equalsIgnoreCase(datatypeField)) continue;
                return datatypeField;
            }
        }
        return "";
    }
}

