/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.generation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import org.apache.commons.lang.ClassUtils;
import org.openl.util.generation.JavaClassGeneratorHelper;
import org.openl.util.generation.JavaGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomSpreadsheetResultJavaGenerator
extends JavaGenerator {
    public static final String SPREADSHEET_METHOD = "getFieldValue";

    public CustomSpreadsheetResultJavaGenerator(Class<?> customSpreadsheetResultClass) {
        super(customSpreadsheetResultClass);
    }

    @Override
    public String generateJavaClass() {
        StringBuffer buf = new StringBuffer(10000);
        this.addComment(buf);
        this.addPackage(buf);
        this.addImports(buf);
        this.addClassDeclaration(buf, ClassUtils.getShortClassName((String)this.getClassNameForGeneration()), ClassUtils.getShortClassName(this.getClassForGeneration().getSuperclass()));
        buf.append(JavaClassGeneratorHelper.getUUID());
        this.addConstructors(buf);
        this.addMethods(buf);
        buf.append("\n}");
        return buf.toString();
    }

    private void addMethods(StringBuffer buf) {
        for (Method method : this.getClassForGeneration().getDeclaredMethods()) {
            if (!method.getName().startsWith("get")) continue;
            this.addDecoratorGetter(buf, method);
        }
    }

    private void addDecoratorGetter(StringBuffer buf, Method method) {
        String fieldName = this.getFieldName(method.getName());
        buf.append(JavaClassGeneratorHelper.getGetterWithCastMethod(method.getReturnType(), SPREADSHEET_METHOD, fieldName));
    }

    public String getFieldName(String methodName) {
        return methodName.substring(3);
    }

    private void addConstructors(StringBuffer buf) {
        for (Constructor<?> constructor : this.getClassForGeneration().getSuperclass().getConstructors()) {
            LinkedHashMap superClassFields = new LinkedHashMap();
            int i = 1;
            for (Class<?> superClassFieldType : constructor.getParameterTypes()) {
                superClassFields.put("par" + i, superClassFieldType);
                ++i;
            }
            String constructorStr = JavaClassGeneratorHelper.getConstructorWithFields(this.getClassForGeneration().getSimpleName(), superClassFields, constructor.getParameterTypes().length);
            buf.append(constructorStr);
        }
    }
}

