/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.formatters;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.util.formatters.IFormatter;

public class NumberFormatter
implements IFormatter {
    private final Log log = LogFactory.getLog(NumberFormatter.class);
    private NumberFormat format;

    public NumberFormatter() {
        this(new DecimalFormat());
    }

    public NumberFormatter(Locale locale) {
        this(NumberFormat.getInstance(locale == null ? Locale.getDefault() : locale));
    }

    public NumberFormatter(NumberFormat format) {
        this.format = format;
    }

    public NumberFormatter(String format) {
        this(new DecimalFormat(format));
    }

    public NumberFormatter(String format, Locale locale) {
        this(new DecimalFormat(format, NumberFormatter.createDecimalFormatSymbols(locale)));
    }

    public String format(Object value) {
        if (!(value instanceof Number)) {
            this.log.debug((Object)("Should be Number: " + value));
            return null;
        }
        return this.format.format(value);
    }

    public Object parse(String value) {
        try {
            return this.format.parse(value);
        }
        catch (ParseException e) {
            this.log.debug((Object)("Could not parse Number: " + value));
            return null;
        }
    }

    private static DecimalFormatSymbols createDecimalFormatSymbols(Locale locale) {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
        symbols.setNaN("NaN");
        return symbols;
    }
}

