/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.formatters;

import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.util.EnumUtils;
import org.openl.util.formatters.IFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumFormatter
implements IFormatter {
    private final Log log = LogFactory.getLog(EnumFormatter.class);
    private Class<?> enumClass;

    public EnumFormatter(Class<?> enumType) {
        this.enumClass = enumType;
    }

    @Override
    public String format(Object value) {
        if (!(value instanceof Enum)) {
            this.log.debug((Object)String.format("Should be a %s value: %s", this.enumClass.toString(), ObjectUtils.toString((Object)value, null)));
            return null;
        }
        return EnumUtils.getName((Enum)value);
    }

    @Override
    public Object parse(String value) {
        return EnumUtils.valueOf(this.enumClass, value);
    }
}

