/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.formatters;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.util.formatters.IFormatter;

public class DateFormatter
implements IFormatter {
    private final Log log = LogFactory.getLog(DateFormatter.class);
    private DateFormat format;

    public DateFormatter() {
        this(new SimpleDateFormat());
    }

    public DateFormatter(Locale locale) {
        this(DateFormat.getDateTimeInstance(3, 3, locale == null ? Locale.getDefault() : locale));
    }

    public DateFormatter(DateFormat format) {
        this.format = format;
    }

    public DateFormatter(String format) {
        try {
            this.format = new SimpleDateFormat(format);
        }
        catch (Exception e) {
            this.log.error((Object)("Could not create format: " + format));
            this.format = new SimpleDateFormat();
        }
    }

    public DateFormatter(String format, Locale locale) {
        try {
            this.format = new SimpleDateFormat(format, locale);
        }
        catch (Exception e) {
            this.log.error((Object)("Could not create format: " + format));
            this.format = DateFormat.getDateTimeInstance(3, 3, locale == null ? Locale.getDefault() : locale);
        }
    }

    public String format(Object value) {
        if (!(value instanceof Date)) {
            this.log.debug((Object)("Should be Date: " + value));
            return null;
        }
        return this.format.format(value);
    }

    public Object parse(String value) {
        try {
            return this.format.parse(value);
        }
        catch (ParseException e) {
            this.log.debug((Object)("Could not parse Date: " + value), (Throwable)e);
            return null;
        }
    }
}

