/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.file;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileStorage {
    private final Log log = LogFactory.getLog(FileStorage.class);
    private final String storagePath;
    private final boolean versioning;

    public FileStorage(String storagePath) {
        this(storagePath, false);
    }

    public FileStorage(String storagePath, boolean versioning) {
        if (storagePath == null) {
            throw new IllegalArgumentException("Illegal storage path");
        }
        this.storagePath = storagePath;
        this.versioning = versioning;
    }

    public synchronized int getSize() {
        return this.list().size();
    }

    public synchronized boolean add(File srcFile) {
        if (srcFile == null) {
            throw new IllegalArgumentException();
        }
        boolean added = false;
        long currentDate = new Date().getTime();
        String innerFilePath = srcFile.getName();
        if (this.versioning) {
            innerFilePath = currentDate + File.separator + innerFilePath;
        }
        String destFilePath = this.getFullFilePath(innerFilePath);
        File destFile = new File(destFilePath);
        try {
            FileUtils.copyFile((File)srcFile, (File)destFile);
            destFile.setLastModified(currentDate);
            added = true;
        }
        catch (Exception e) {
            this.log.error((Object)("Can't add file " + srcFile.getName()), (Throwable)e);
        }
        return added;
    }

    public synchronized boolean delete(String fileName) {
        return this.delete((IOFileFilter)new NameFileFilter(fileName));
    }

    public synchronized boolean delete(String[] fileNames) {
        return this.delete((IOFileFilter)new NameFileFilter(fileNames));
    }

    public synchronized boolean delete(IOFileFilter fileFilter) {
        Collection<File> filesToDelete = this.list(fileFilter);
        boolean deleted = false;
        for (File fileToDelete : filesToDelete) {
            if (this.versioning && !fileToDelete.getParent().equals(this.storagePath)) {
                fileToDelete = fileToDelete.getParentFile();
            }
            if (this.delete(fileToDelete)) continue;
            deleted = false;
            break;
        }
        return deleted;
    }

    private boolean delete(File file) {
        boolean deleted = false;
        try {
            FileUtils.forceDelete((File)file);
            deleted = true;
        }
        catch (Exception e) {
            this.log.error((Object)("Can't delete file " + file.getName()), (Throwable)e);
        }
        return deleted;
    }

    public synchronized void clean() {
        File storageDir = this.getStorageDir();
        if (storageDir.exists()) {
            try {
                FileUtils.cleanDirectory((File)storageDir);
            }
            catch (Exception e) {
                this.log.error((Object)("Can't clean folder " + storageDir.getName()), (Throwable)e);
            }
        }
    }

    public synchronized Collection<File> list() {
        return this.list(TrueFileFilter.TRUE);
    }

    public synchronized Collection<File> list(String fileName) {
        return this.list((IOFileFilter)new NameFileFilter(fileName));
    }

    public synchronized Collection<File> list(String[] fileNames) {
        return this.list((IOFileFilter)new NameFileFilter(fileNames));
    }

    public synchronized Collection<File> list(IOFileFilter fileFilter) {
        File storageDir = this.getStorageDir();
        if (storageDir.exists()) {
            return FileUtils.listFiles((File)storageDir, (IOFileFilter)fileFilter, (IOFileFilter)TrueFileFilter.TRUE);
        }
        return Collections.emptyList();
    }

    private File getStorageDir() {
        return new File(this.storagePath);
    }

    private String getFullFilePath(String innerPath) {
        return this.storagePath + File.separator + innerPath;
    }
}

