/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.benchmark;

public class RunInfo {
    long times;
    long ms;
    long memoryBefore;
    long memoryDirtyAfter;
    long memoryCleanAfter;

    public RunInfo(long times, long ms, long memoryBefore, long memoryDirtyAfter, long memoryCleanAfter) {
        this.times = times;
        this.ms = ms;
        this.memoryBefore = memoryBefore;
        this.memoryDirtyAfter = memoryDirtyAfter;
        this.memoryCleanAfter = memoryCleanAfter;
    }

    public RunInfo(long runs, long ms) {
        this.times = runs;
        this.ms = ms;
    }

    public double avgRunms() {
        return (double)this.ms / (double)this.times;
    }

    public double avgTimesSec() {
        return (double)this.times * 1000.0 / (double)this.ms;
    }

    public String toString() {
        return "[" + this.times + " : " + this.ms + "]";
    }

    public double bytesPerRun() {
        return (double)(this.memoryDirtyAfter - this.memoryBefore) / (double)this.times;
    }

    public double leakedBytesPerRun() {
        return (double)(this.memoryCleanAfter - this.memoryBefore) / (double)this.times;
    }

    public double usedBytes() {
        return this.memoryDirtyAfter - this.memoryBefore;
    }

    public double leakedBytes() {
        return this.memoryCleanAfter - this.memoryBefore;
    }
}

