/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.benchmark;

import org.openl.util.benchmark.Benchmark;
import org.openl.util.benchmark.BenchmarkInfo;
import org.openl.util.benchmark.BenchmarkUnit;

public class Profiler {
    int N = 10;
    int minms = 10000;

    public Profiler(int N) {
        this.N = N;
    }

    public void profileUnit(Unit unit) throws Exception {
        long start = System.currentTimeMillis();
        BenchmarkUnit bu = unit.makeBenchMarkUnit();
        long end = System.currentTimeMillis();
        long initTime = end - start;
        int ms = (int)Math.max(initTime * (long)this.N, (long)this.minms);
        System.out.println("Startup time " + initTime + "ms");
        if (this.N < 2) {
            bu.runNtimes(1L);
            return;
        }
        System.out.println("Going to profile for " + ms + "ms");
        BenchmarkUnit[] buu = new BenchmarkUnit[]{bu};
        BenchmarkInfo bi = new Benchmark(buu).runUnit(bu, ms, false);
        System.out.println(bi);
    }

    public static abstract class Unit {
        public abstract BenchmarkUnit makeBenchMarkUnit() throws Exception;
    }
}

