/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.benchmark;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.openl.util.IdMap;
import org.openl.util.IdObject;
import org.openl.util.RuntimeExceptionWrapper;
import org.openl.util.benchmark.Benchmark;
import org.openl.util.benchmark.BenchmarkInfo;
import org.openl.util.benchmark.BenchmarkUnit;

public class BenchmarkJavaBasics {
    private static ThreadLocal<Object> tracer = new ThreadLocal();

    public static boolean isTracerOn() {
        return tracer.get() != null;
    }

    public static void main(String[] args) throws Exception {
        BenchmarkUnit[] bu = new BenchmarkUnit[]{new Empty(), new Call(), new Invoke(), new MapGet(), new MapInternGet(), new IDMapGet(), new ThreadLocAccess(), new TreeMapGet(), new TreeMapGetFirstKey(), new BSearch(), new ConstructorDirect(), new ConstructorNewInstance(), new CurrentTimeMillis(), new NanoTime()};
        List<BenchmarkInfo> res = new Benchmark(bu).measureAllInList(1000);
        for (BenchmarkInfo bi : res) {
            System.out.println(bi);
        }
    }

    public int add(int x, int y) {
        return x + y;
    }

    private static class ConstructorNewInstance
    extends BenchmarkUnit {
        Constructor<Double> ctr;

        ConstructorNewInstance() {
            try {
                this.ctr = Double.class.getConstructor(Double.TYPE);
            }
            catch (SecurityException e) {
                throw RuntimeExceptionWrapper.wrap(e);
            }
            catch (NoSuchMethodException e) {
                throw RuntimeExceptionWrapper.wrap(e);
            }
        }

        protected void run() throws Exception {
            double ddd = 4.345;
            Double d = this.ctr.newInstance(ddd);
        }
    }

    private static class ConstructorDirect
    extends BenchmarkUnit {
        private ConstructorDirect() {
        }

        protected void run() throws Exception {
            double ddd = 4.345;
            Double d = new Double(ddd);
        }
    }

    private static class TreeMapGetFirstKey
    extends BenchmarkUnit {
        private TreeMap<Integer, String> map;
        private Integer key = new Integer(51);

        private TreeMapGetFirstKey() throws Exception {
            this.map = new TreeMap();
            for (int i = 0; i < 100; ++i) {
                this.map.put(new Integer(i * 2), "Xyz" + i);
            }
        }

        protected void run() throws Exception {
            Iterator<String> it = this.map.tailMap(this.key).values().iterator();
            if (it.hasNext()) {
                it.next();
            }
        }
    }

    private static class TreeMapGet
    extends BenchmarkUnit {
        private TreeMap<Integer, String> map;
        private Integer key = new Integer(50);

        private TreeMapGet() throws Exception {
            this.map = new TreeMap();
            for (int i = 0; i < 100; ++i) {
                this.map.put(new Integer(i * 2), "Xyz" + i);
            }
        }

        protected void run() throws Exception {
            this.map.get(this.key);
        }
    }

    private static class ThreadLocAccess
    extends BenchmarkUnit {
        private ThreadLocAccess() {
        }

        protected void run() throws Exception {
            BenchmarkJavaBasics.isTracerOn();
        }
    }

    private static class NanoTime
    extends BenchmarkUnit {
        private NanoTime() {
        }

        protected void run() throws Exception {
            long abc = System.nanoTime();
        }
    }

    private static class CurrentTimeMillis
    extends BenchmarkUnit {
        private CurrentTimeMillis() {
        }

        protected void run() throws Exception {
            long abc = System.currentTimeMillis();
        }
    }

    private static class MapInternGet
    extends BenchmarkUnit {
        private HashMap<String, String> map;
        private String key = "Xyz37".intern();

        private MapInternGet() throws Exception {
            this.map = new HashMap();
            for (int i = 0; i < 100; ++i) {
                this.map.put(("Xyz" + i).intern(), "Xyz" + i);
            }
        }

        protected void run() throws Exception {
            this.map.get(this.key);
        }
    }

    private static class MapGet
    extends BenchmarkUnit {
        private HashMap<String, String> map = new HashMap();
        private String key = "Xyz37";

        private MapGet() throws Exception {
            for (int i = 0; i < 100; ++i) {
                this.map.put("Xyz" + i, "Xyz" + i);
            }
        }

        protected void run() throws Exception {
            this.map.get(this.key);
        }
    }

    private static class Invoke
    extends BenchmarkUnit {
        private Method m = BenchmarkJavaBasics.class.getMethod("add", Integer.TYPE, Integer.TYPE);
        private Object[] params = new Object[]{new Integer(10), new Integer(15)};
        private Object bjb = new BenchmarkJavaBasics();

        private Invoke() throws Exception {
        }

        protected void run() throws Exception {
            this.m.invoke(this.bjb, this.params);
        }
    }

    private static class IDMapGet
    extends BenchmarkUnit {
        private IdMap map;
        private int key = "Xyz37".hashCode();

        private IDMapGet() throws Exception {
            this.map = new IdMap(107);
            for (int i = 0; i < 100; ++i) {
                this.map.add(new IdObject(("Xyz" + i).hashCode()));
            }
        }

        protected void run() throws Exception {
            this.map.get(this.key);
        }
    }

    private static class Empty
    extends BenchmarkUnit {
        private Empty() {
        }

        protected void run() throws Exception {
        }
    }

    private static class Call
    extends BenchmarkUnit {
        private BenchmarkJavaBasics bjb = new BenchmarkJavaBasics();

        private Call() throws Exception {
        }

        protected void run() throws Exception {
            this.bjb.add(10, 15);
        }
    }

    private static class BSearch
    extends BenchmarkUnit {
        private static int N = 100;
        private int[] buf = new int[N];
        private int key = 51;

        private BSearch() throws Exception {
            for (int i = 0; i < N; ++i) {
                this.buf[i] = i * 4;
            }
        }

        protected void run() throws Exception {
            Arrays.binarySearch(this.buf, this.key);
        }
    }
}

