/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.benchmark;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openl.util.benchmark.BenchmarkOrder;
import org.openl.util.benchmark.BenchmarkUnit;
import org.openl.util.benchmark.RunInfo;

public class BenchmarkInfo {
    BenchmarkUnit unit;
    long firstRunms;
    List<RunInfo> runs = new ArrayList<RunInfo>();
    Throwable error;
    String name;

    public static BenchmarkOrder[] order(BenchmarkInfo[] bi) {
        ArrayList<BenchmarkOrder> list = new ArrayList<BenchmarkOrder>();
        for (int i = 0; i < bi.length; ++i) {
            if (bi[i] == null) continue;
            list.add(new BenchmarkOrder(i, bi[i]));
        }
        Collections.sort(list);
        BenchmarkOrder[] bo = list.toArray(new BenchmarkOrder[0]);
        for (int i = 0; i < bo.length; ++i) {
            bo[i].setOrder(i + 1);
            bo[i].setRatio(bo[0].info.drunsunitsec() / bo[i].info.drunsunitsec());
        }
        BenchmarkOrder[] bores = new BenchmarkOrder[bi.length];
        for (int i = 0; i < bo.length; ++i) {
            bores[bo[i].getIndex()] = bo[i];
        }
        return bores;
    }

    public static String printDouble(double d) {
        if (d >= 1000.0) {
            DecimalFormat fmt = new DecimalFormat("#,##0");
            return fmt.format(d);
        }
        if (d >= 1.0) {
            DecimalFormat fmt = new DecimalFormat("#,##0.00");
            return fmt.format(d);
        }
        if (d > 0.1) {
            return BenchmarkInfo.printDouble(d, 3);
        }
        if (d > 0.01) {
            return BenchmarkInfo.printDouble(d, 4);
        }
        if (d > 0.001) {
            return BenchmarkInfo.printDouble(d, 5);
        }
        return BenchmarkInfo.printDouble(d, 6);
    }

    public static String printDouble(double d, int decimals) {
        NumberFormat fmt = NumberFormat.getNumberInstance();
        fmt.setMaximumFractionDigits(decimals);
        fmt.setMinimumFractionDigits(decimals);
        return fmt.format(d);
    }

    public static String printLargeDouble(double d) {
        DecimalFormat fmt = new DecimalFormat("#,##0.00");
        return fmt.format(d);
    }

    public BenchmarkInfo(Throwable t, BenchmarkUnit bu, String name) {
        this.error = t;
        this.unit = bu;
        this.name = name;
    }

    public double avg() {
        long n = 0L;
        double sum = 0.0;
        for (int i = 0; i < this.runs.size(); ++i) {
            RunInfo run = this.runs.get(i);
            n += run.times;
            sum += (double)run.ms;
        }
        return sum / (double)n;
    }

    public double avgMemory() {
        long n = 0L;
        double sum = 0.0;
        for (int i = 0; i < this.runs.size(); ++i) {
            RunInfo run = this.runs.get(i);
            n += run.times;
            sum += run.usedBytes();
        }
        return sum / (double)n;
    }

    public double avgLeaked() {
        long n = 0L;
        double sum = 0.0;
        for (int i = 0; i < this.runs.size(); ++i) {
            RunInfo run = this.runs.get(i);
            n += run.times;
            sum += run.leakedBytes();
        }
        return sum / (double)n;
    }

    public double deviation() {
        int n = 0;
        double sum = 0.0;
        double sum2 = 0.0;
        for (int i = 0; i < this.runs.size(); ++i) {
            RunInfo run = this.runs.get(i);
            n = (int)((long)n + run.times);
            sum += (double)run.ms;
            sum2 += run.avgRunms() * (double)run.ms;
        }
        return Math.sqrt((sum2 - sum / (double)n * sum) / (double)n);
    }

    public double drunsunitsec() {
        return (double)(1000 * this.unit.nUnitRuns()) / this.avg();
    }

    public Throwable getError() {
        return this.error;
    }

    public String getName() {
        return this.name;
    }

    public BenchmarkUnit getUnit() {
        return this.unit;
    }

    public String msrun() {
        return BenchmarkInfo.printDouble(this.avg());
    }

    public String msrununit() {
        return BenchmarkInfo.printDouble(this.avg() / (double)this.unit.nUnitRuns());
    }

    public String runssec() {
        return BenchmarkInfo.printLargeDouble(1000.0 / this.avg());
    }

    public String runsunitsec() {
        return BenchmarkInfo.printLargeDouble(this.drunsunitsec());
    }

    public String toString() {
        return this.getName() + " = " + '\t' + this.msrun() + " ms/run" + '\t' + this.runssec() + " runs/sec" + '\t' + " First Run: " + BenchmarkInfo.printDouble(this.firstRunms) + "ms" + '\t' + "Memory: " + BenchmarkInfo.printLargeDouble(this.avgMemory() / (double)this.unit.nUnitRuns()) + "b/unit" + '\t' + "Leaked: " + BenchmarkInfo.printLargeDouble(this.avgLeaked() / (double)this.unit.nUnitRuns()) + "b/unit";
    }

    public String printUnits() {
        return this.msrununit() + "ms/" + this.unit.unitName()[0] + "  " + this.drunsunitsec() + " units/sec";
    }

    String unitDescription() {
        if (this.unit.getDescription() == null) {
            return this.unit.getName();
        }
        return this.unit.getDescription();
    }

    public String unitName() {
        return this.unit.nUnitRuns() == 1 ? this.unit.unitName()[0] : this.unit.unitName()[1];
    }
}

