/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.benchmark;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openl.util.Log;
import org.openl.util.benchmark.BenchmarkInfo;
import org.openl.util.benchmark.BenchmarkUnit;
import org.openl.util.benchmark.RunInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Benchmark {
    BenchmarkUnit[] _units;
    HashMap<String, BenchmarkInfo> _measurements = null;

    public Benchmark(BenchmarkUnit[] units) {
        this._units = units;
    }

    BenchmarkUnit findUnit(String name) {
        for (int i = 0; i < this._units.length; ++i) {
            if (!this._units[i].getName().equals(name)) continue;
            return this._units[i];
        }
        throw new RuntimeException("Unit " + name + " not found");
    }

    public static long getCleanMemorySize() {
        long prevUsedMemory = Benchmark.getUsedMemorySize();
        while (true) {
            System.gc();
            if (prevUsedMemory - Benchmark.getUsedMemorySize() < 1024L) {
                return Benchmark.getUsedMemorySize();
            }
            prevUsedMemory = Benchmark.getUsedMemorySize();
        }
    }

    public static long getUsedMemorySize() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    RunInfo makeRun(BenchmarkUnit bu, int minRuns, int ms) throws Exception {
        int minMillis = ms == -1 ? bu.getMinms() : ms;
        long runs = minRuns;
        while (true) {
            long time = 0L;
            if (bu.isTestMemory()) {
                long memoryBefore = Benchmark.getCleanMemorySize();
                time = bu.millisecondsToRun(runs);
                long memoryDirtyAfter = Benchmark.getUsedMemorySize();
                long memoryCleanAfter = Benchmark.getCleanMemorySize();
                if (time > (long)minMillis) {
                    return new RunInfo(runs, time, memoryBefore, memoryDirtyAfter, memoryCleanAfter);
                }
            } else {
                time = bu.millisecondsToRun(runs);
                if (time > (long)minMillis) {
                    return new RunInfo(runs, time);
                }
            }
            if (time <= 0L) {
                time = 1L;
            }
            double mult = Math.min(200.0, (double)minMillis * 1.1 / (double)time);
            long newRuns = (long)Math.ceil((double)runs * mult);
            runs = Math.max(runs + 1L, newRuns);
        }
    }

    public String makeTableHeader(String separator) {
        String res = "";
        for (int i = 0; i < this._units.length; ++i) {
            res = res + this._units[i].getName() + separator;
        }
        return res;
    }

    public String makeTableRow(Map<String, BenchmarkInfo> map, String separator) {
        String res = "";
        for (int i = 0; i < this._units.length; ++i) {
            BenchmarkInfo info = map.get(this._units[i].getName());
            res = res + BenchmarkInfo.printDouble(info.avg()) + separator;
        }
        return res;
    }

    public Map<String, BenchmarkInfo> measureAll(int ms) throws Exception {
        this._measurements = new HashMap();
        for (int i = 0; i < this._units.length; ++i) {
            this.measureUnit(this._units[i], ms);
        }
        return this._measurements;
    }

    public List<BenchmarkInfo> measureAllInList(int ms) throws Exception {
        this._measurements = new HashMap();
        ArrayList<BenchmarkInfo> list = new ArrayList<BenchmarkInfo>();
        for (int i = 0; i < this._units.length; ++i) {
            list.add(this.measureUnit(this._units[i], ms));
        }
        return list;
    }

    public BenchmarkInfo measureUnit(BenchmarkUnit bu, int ms) throws Exception {
        Log.info("Benchmarking Unit " + bu.getName());
        if (this._measurements == null) {
            this._measurements = new HashMap();
        }
        this.satisfyPreconditions(bu);
        return this.runUnit(bu, ms, false);
    }

    public BenchmarkInfo measureUnit(String name, int ms) throws Exception {
        return this.measureUnit(this.findUnit(name), ms);
    }

    public void printResult(Map<String, BenchmarkInfo> map, PrintStream ps) {
        for (int i = 0; i < this._units.length; ++i) {
            BenchmarkInfo info = map.get(this._units[i].getName());
            ps.println(info);
        }
    }

    public void profileUnit(String name, int times) throws Exception {
        if (this._measurements == null) {
            this._measurements = new HashMap();
        }
        BenchmarkUnit bu = this.findUnit(name);
        this.satisfyPreconditions(bu);
        bu.millisecondsToRun(times == -1 ? 1L : (long)times);
    }

    public BenchmarkInfo runUnit(BenchmarkUnit bu, int ms, boolean once) throws Exception {
        BenchmarkInfo bi;
        if (this._measurements == null) {
            this._measurements = new HashMap();
        }
        if ((bi = this._measurements.get(bu.getName())) == null) {
            bi = new BenchmarkInfo(null, bu, bu.getName());
            bi.firstRunms = bu.millisecondsToRun();
            this._measurements.put(bu.getName(), bi);
        }
        if (once) {
            return bi;
        }
        RunInfo info = this.makeRun(bu, bu.getMinRuns(), ms);
        bi.runs.add(info);
        return bi;
    }

    public void satisfyPreconditions(BenchmarkUnit bu) throws Exception {
        String[] names = bu.performAfter();
        for (int i = 0; i < names.length; ++i) {
            BenchmarkUnit prev = this.findUnit(names[i]);
            BenchmarkInfo bi = this._measurements.get(bu.getName());
            if (bi != null) continue;
            this.satisfyPreconditions(prev);
            this.runUnit(prev, 1, true);
        }
    }
}

