/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.NestableRuntimeException;

public class RuntimeExceptionWrapper {
    public static RuntimeException wrap(String msg, Throwable cause) {
        return new NestableRuntimeException(msg, cause);
    }

    public static RuntimeException wrap(Throwable cause) {
        if (cause instanceof RuntimeException) {
            return (RuntimeException)cause;
        }
        return new NestableRuntimeException(RuntimeExceptionWrapper.getErrorMessage(cause), cause);
    }

    private static String getErrorMessage(Throwable error) {
        String message = error.getMessage();
        if (StringUtils.isBlank((String)message) && error.getCause() != null) {
            message = error.getCause().getMessage();
        }
        return message;
    }
}

