/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import java.util.Enumeration;
import java.util.Iterator;
import org.openl.util.AIndexedIterator;
import org.openl.util.AOpenIterator;
import org.openl.util.IOpenIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenIterator<T>
extends AOpenIterator.SimpleIteratorWrapper<T> {
    public static <T> IOpenIterator<T> fromArray(T[] ary) {
        if (ary == null || ary.length == 0) {
            return OpenIterator.empty();
        }
        return new AIndexedIterator.ArrayIterator<T>(ary);
    }

    public static IOpenIterator<Object> fromArrayObj(Object ary) {
        if (ary == null) {
            return OpenIterator.empty();
        }
        return new AIndexedIterator.AnyArrayIterator(ary);
    }

    public static <T> IOpenIterator<T> fromEnumeration(Enumeration<T> enumeration) {
        if (enumeration == null) {
            return OpenIterator.empty();
        }
        return new EnumerationIterator<T>(enumeration);
    }

    public OpenIterator(Iterator<T> it) {
        super(it);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnumerationIterator<T>
    extends AOpenIterator<T> {
        private Enumeration<T> enumeration;

        EnumerationIterator(Enumeration<T> enumeration) {
            this.enumeration = enumeration;
        }

        @Override
        public boolean hasNext() {
            return this.enumeration.hasMoreElements();
        }

        @Override
        public T next() {
            return this.enumeration.nextElement();
        }
    }
}

