/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberUtils {
    public static final double FLOAT_MIN_VALUE = -3.4028234663852886E38;
    public static final double DOUBLE_MIN_VALUE = -1.7976931348623157E308;

    private NumberUtils() {
    }

    public static Object intOrDouble(double value) {
        int intValue = (int)value;
        if (value == (double)intValue) {
            return intValue;
        }
        return value;
    }

    public static Number getMinValue(Class<?> numberClass) {
        Number minValue = null;
        if (numberClass == Byte.TYPE || numberClass == Byte.class) {
            minValue = (byte)-128;
        } else if (numberClass == Short.TYPE || numberClass == Short.class) {
            minValue = (short)Short.MIN_VALUE;
        } else if (numberClass == Integer.TYPE || numberClass == Integer.class) {
            minValue = Integer.MIN_VALUE;
        } else if (numberClass == Long.TYPE || numberClass == Long.class) {
            minValue = Long.MIN_VALUE;
        } else if (numberClass == Float.TYPE || numberClass == Float.class) {
            minValue = -3.4028234663852886E38;
        } else if (numberClass == Double.TYPE || numberClass == Double.class) {
            minValue = -1.7976931348623157E308;
        }
        return minValue;
    }

    public static Number getMaxValue(Class<?> numberClass) {
        Number minValue = null;
        if (numberClass == Byte.TYPE || numberClass == Byte.class) {
            minValue = (byte)127;
        } else if (numberClass == Short.TYPE || numberClass == Short.class) {
            minValue = (short)Short.MAX_VALUE;
        } else if (numberClass == Integer.TYPE || numberClass == Integer.class) {
            minValue = Integer.MAX_VALUE;
        } else if (numberClass == Long.TYPE || numberClass == Long.class) {
            minValue = Long.MAX_VALUE;
        } else if (numberClass == Float.TYPE || numberClass == Float.class) {
            minValue = Float.valueOf(Float.MAX_VALUE);
        } else if (numberClass == Double.TYPE || numberClass == Double.class) {
            minValue = Double.MAX_VALUE;
        }
        return minValue;
    }

    public static boolean isPrimitive(String canonicalTypeName) {
        return StringUtils.isNotBlank((String)canonicalTypeName) && (canonicalTypeName.contains("byte") || canonicalTypeName.contains("short") || canonicalTypeName.contains("int") || canonicalTypeName.contains("long") || canonicalTypeName.contains("float") || canonicalTypeName.contains("double") || canonicalTypeName.contains("boolean") || canonicalTypeName.contains("char"));
    }

    public static Class<?> getWrapperType(String primitiveName) {
        Class wrapperType = null;
        if (primitiveName.equals("byte")) {
            wrapperType = Byte.class;
        } else if (primitiveName.equals("short")) {
            wrapperType = Short.class;
        } else if (primitiveName.equals("int")) {
            wrapperType = Integer.class;
        } else if (primitiveName.equals("long")) {
            wrapperType = Long.class;
        } else if (primitiveName.equals("float")) {
            wrapperType = Float.class;
        } else if (primitiveName.equals("double")) {
            wrapperType = Double.class;
        } else if (primitiveName.equals("boolean")) {
            wrapperType = Boolean.class;
        } else if (primitiveName.equals("char")) {
            wrapperType = Character.class;
        }
        return wrapperType;
    }
}

