/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import java.util.HashMap;
import org.openl.util.FastLinkedList;
import org.openl.util.LRUCacheEntry;
import org.openl.util.LRUStatistics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LastRecentlyUsedCache<E extends LRUCacheEntry<K, T>, K, T> {
    private int maxLimit;
    LRUStatistics statistics = new LRUStatistics();
    FastLinkedList<E> lruList = new FastLinkedList();
    HashMap<K, FastLinkedList.Entry<E>> map = new HashMap();

    public LastRecentlyUsedCache() {
        this(300);
    }

    public LastRecentlyUsedCache(int maxLimit) {
        this.maxLimit = maxLimit;
    }

    private synchronized FastLinkedList.Entry<E> getNode(K key) {
        FastLinkedList.Entry<E> e = this.map.get(key);
        if (e != null) {
            this.lruList.moveToLast(e);
            ++this.statistics.hit;
            return e;
        }
        ++this.statistics.miss;
        return null;
    }

    public synchronized E get(K key) {
        FastLinkedList.Entry<E> entry = this.getNode(key);
        return (E)(entry == null ? null : (LRUCacheEntry)entry.element);
    }

    public synchronized void put(K key, E element) {
        FastLinkedList.Entry<E> e;
        if (this.lruList.size() >= this.maxLimit) {
            e = this.lruList.getFirstEntry();
            this.lruList.removeEntry(e);
            if (e.element != null) {
                ((LRUCacheEntry)e.element).removeHandledObject();
                this.map.remove(((LRUCacheEntry)e.element).getKey());
                ++this.statistics.removed;
            }
        }
        this.lruList.addLast(element);
        e = this.lruList.getLastEntry();
        this.map.put(key, e);
    }

    public LRUStatistics getStatistics() {
        return this.statistics;
    }
}

