/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FileTool {
    public static final String DEFAULT_CHARACTER_ENCODING = "UTF-8";
    public static final int DEFAULT_READ_BUFFER_SIZE = 1024;
    public static final String INTERNAL_PATH_SEPARATOR = ";";
    public static final String INTERNAL_SEPARATOR = "/";
    public static final char INTERNAL_PATH_SEPARATOR_CHAR = ';';
    public static final char INTERNAL_SEPARATOR_CHAR = '/';

    public static File buildRelativePath(File startDir, File targetFile) throws IOException {
        int i;
        if (startDir == null) {
            return targetFile.isFile() ? targetFile.getParentFile() : targetFile;
        }
        if (startDir.equals(targetFile)) {
            return new File(".");
        }
        File[] pfDir = FileTool.parents(startDir);
        File[] pfTarget = FileTool.parents(targetFile);
        int size = Math.min(pfDir.length, pfTarget.length);
        int lastEqual = -1;
        for (int i2 = 0; i2 < size; ++i2) {
            if (!pfDir[i2].equals(pfTarget[i2])) continue;
            lastEqual = i2;
        }
        if (lastEqual == -1) {
            return targetFile.getAbsoluteFile();
        }
        int stepsToCommonParent = pfDir.length - 1 - lastEqual;
        String path = ".";
        for (i = 0; i < stepsToCommonParent; ++i) {
            path = i == 0 ? ".." : path + "/..";
        }
        stepsToCommonParent = pfTarget.length - 1 - lastEqual;
        for (i = 0; i < stepsToCommonParent; ++i) {
            path = path + INTERNAL_SEPARATOR + pfTarget[lastEqual + i + 1].getName();
        }
        return new File(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized int compareFileSource(String fname, byte[] src) throws Exception {
        if (!new File(fname).isFile()) {
            return -1;
        }
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        int result = 0;
        try {
            int rd;
            fis = new FileInputStream(fname);
            bis = new BufferedInputStream(fis);
            int index = -1;
            while ((rd = bis.read()) != -1) {
                if (src.length > ++index) {
                    if (src[index] == (byte)rd) continue;
                    result = -1;
                    break;
                }
                result = 1;
                break;
            }
            if (result == 0 && src.length > index + 1) {
                result = -1;
            }
        }
        finally {
            if (bis != null) {
                bis.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized int compareFileSource(String fname, String src) throws Exception {
        if (!new File(fname).isFile()) {
            return -1;
        }
        FileInputStream fis = null;
        BufferedReader bis = null;
        int result = 0;
        try {
            int rd;
            fis = new FileInputStream(fname);
            bis = new BufferedReader(new InputStreamReader((InputStream)fis, DEFAULT_CHARACTER_ENCODING));
            int index = -1;
            while ((rd = bis.read()) != -1) {
                if (src.length() > ++index) {
                    if (src.charAt(index) == (char)rd) continue;
                    result = -1;
                    break;
                }
                result = 1;
                break;
            }
            if (result == 0 && src.length() > index + 1) {
                result = -1;
            }
        }
        finally {
            if (bis != null) {
                bis.close();
            }
        }
        return result;
    }

    public static void copyDir(String srcDir, final String dstDir, FilenameFilter filter) throws Exception {
        DirectoryIterator di = new DirectoryIterator(srcDir, filter);
        DirectoryIterator.FileHandler fh = new DirectoryIterator.FileHandler(){

            public void processFile(File f, String local_path) throws Exception {
                FileTool.copyFile(f, new File(dstDir + '/' + local_path));
            }
        };
        di.iterate(fh, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dst) throws IOException {
        File dstCan;
        File srcCan = src.getCanonicalFile();
        if (srcCan.equals(dstCan = dst.getCanonicalFile())) {
            return;
        }
        dstCan.getParentFile().mkdirs();
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            int len;
            fis = new FileInputStream(srcCan);
            fos = new FileOutputStream(dstCan);
            byte[] buf = new byte[8192];
            while ((len = fis.read(buf)) > 0) {
                fos.write(buf, 0, len);
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    public static void copyFileToDir(File src, File dstDir) throws IOException {
        FileTool.copyFile(src, new File(dstDir.getPath() + File.separator + src.getName()));
    }

    public static File findCommonParent(File f1, File f2) throws IOException {
        if (f1.equals(f2)) {
            return f1;
        }
        if (FileTool.isParentOf(f1, f2)) {
            return f1;
        }
        if (FileTool.isParentOf(f2, f1)) {
            return f2;
        }
        File[] pf1 = FileTool.parents(f1);
        File[] pf2 = FileTool.parents(f2);
        int size = Math.min(pf1.length, pf2.length);
        for (int i = 0; i < size; ++i) {
            if (pf1[i].equals(pf2[i])) continue;
            return i == 0 ? null : pf1[i - 1];
        }
        return size == 0 ? null : pf1[size - 1];
    }

    public static String internalSeparators(String path) {
        if (path == null) {
            return null;
        }
        String tmp = path.replace(File.separatorChar, '/');
        tmp = tmp.replace(File.pathSeparatorChar, ';');
        return tmp;
    }

    public static boolean isParentOf(File parent, File child) throws IOException {
        String ps = parent.getCanonicalPath();
        String cs = child.getCanonicalPath();
        return cs.indexOf(ps) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized String loadFile(InputStream fs) throws Exception {
        StringBuffer buf = new StringBuffer();
        BufferedReader bis = null;
        try {
            int rd;
            bis = new BufferedReader(new InputStreamReader(fs, DEFAULT_CHARACTER_ENCODING));
            while ((rd = bis.read()) != -1) {
                buf.append((char)rd);
            }
        }
        finally {
            if (bis != null) {
                bis.close();
            }
        }
        return buf.toString();
    }

    public static String loadFile(Reader reader) throws Exception {
        int n;
        StringBuffer buf = new StringBuffer(1024);
        char[] c = new char[1024];
        while ((n = reader.read(c)) > 0) {
            buf.append(c, 0, n);
        }
        return buf.toString();
    }

    public static synchronized String loadFile(String fname) throws Exception {
        return FileTool.loadFile(new FileInputStream(fname));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized byte[] loadFileToByteArray(InputStream fis) throws Exception {
        BufferedInputStream bis = null;
        byte[] buf = new byte[fis.available()];
        try {
            bis = new BufferedInputStream(fis);
            bis.read(buf, 0, buf.length);
        }
        finally {
            bis.close();
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized byte[] loadFileToByteArray(String fname) throws Exception {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        File file = new File(fname);
        byte[] buf = new byte[(int)file.length()];
        try {
            fis = new FileInputStream(fname);
            bis = new BufferedInputStream(fis);
            bis.read(buf, 0, buf.length);
        }
        finally {
            bis.close();
        }
        return buf;
    }

    static File[] parents(File f) throws IOException {
        f = f.getCanonicalFile();
        ArrayList<File> v = new ArrayList<File>();
        v.add(f);
        while ((f = f.getParentFile()) != null) {
            v.add(f.getCanonicalFile());
        }
        int size = v.size();
        File[] ff = new File[size];
        for (int i = 0; i < size; ++i) {
            ff[i] = (File)v.get(size - 1 - i);
        }
        return ff;
    }

    private static void removeChildren(File dir) {
        Log log = LogFactory.getLog(FileTool.class);
        File[] file = dir.listFiles();
        for (int i = 0; i < file.length; ++i) {
            if (file[i].isDirectory()) {
                FileTool.removeChildren(file[i]);
            }
            if (file[i].delete()) continue;
            log.warn((Object)("Cant delete file/dir: " + file[i].getAbsolutePath()));
        }
    }

    public static void removeDirRecursive(String path) {
        File dir = new File(path);
        if (!dir.exists()) {
            return;
        }
        if (dir.isDirectory()) {
            FileTool.removeChildren(dir);
            dir.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFile(OutputStream os, String s) throws Exception {
        Writer fw = null;
        try {
            fw = new BufferedWriter(new OutputStreamWriter(os, DEFAULT_CHARACTER_ENCODING));
            fw.write(s);
        }
        finally {
            if (fw != null) {
                fw.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFile(String fname, byte[] src) throws Exception {
        File file = new File(fname);
        File parentFile = file.getParentFile();
        if (!parentFile.exists() && !parentFile.mkdirs()) {
            throw new Exception("Can not create " + parentFile.getAbsolutePath());
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            os.write(src);
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    public static void saveFile(String fname, String s) throws Exception {
        FileTool.saveFile(fname, s, false);
    }

    public static void saveFile(String fname, String s, boolean compareBeforeSave) throws Exception {
        Log log = LogFactory.getLog(FileTool.class);
        try {
            if (compareBeforeSave && FileTool.compareFileSource(fname, s) == 0) {
                return;
            }
        }
        catch (Exception ex) {
            log.warn((Object)ex);
        }
        File file = new File(fname);
        File parentFile = file.getParentFile();
        if (!parentFile.exists() && !parentFile.mkdirs()) {
            throw new Exception("Can not create " + parentFile.getAbsolutePath());
        }
        FileTool.saveFile(new FileOutputStream(file), s);
    }

    public static String systemSeparators(String path) {
        if (path == null) {
            return null;
        }
        String tmp = path.replace('/', File.separatorChar);
        tmp = tmp.replace(';', File.pathSeparatorChar);
        return tmp;
    }

    public static boolean containsFile(File f, String fname, boolean isDir) throws IOException {
        File ff = new File(f.getCanonicalPath(), fname);
        return ff.exists() && ff.isDirectory() == isDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsFileText(File dir, String fname, String content) throws IOException {
        File f = new File(dir.getCanonicalPath(), fname);
        FileReader fr = new FileReader(f);
        BufferedReader br = new BufferedReader(fr);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (line.indexOf(content) < 0) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            br.close();
            fr.close();
        }
    }

    public static File toFile(InputStream source, String pathName) {
        Log log = LogFactory.getLog(FileTool.class);
        File file = null;
        try {
            file = new File(pathName);
            FileUtils.copyInputStreamToFile((InputStream)source, (File)file);
        }
        catch (IOException e) {
            log.error((Object)("Error when creating file: " + pathName), (Throwable)e);
        }
        return file;
    }

    public static File toTempFile(InputStream source, String fileName) {
        Log log = LogFactory.getLog(FileTool.class);
        File file = null;
        try {
            file = File.createTempFile(fileName, null);
            FileUtils.copyInputStreamToFile((InputStream)source, (File)file);
        }
        catch (IOException e) {
            log.error((Object)("Error when creating file: " + fileName), (Throwable)e);
        }
        return file;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DirectoryIterator {
        String _root;
        FilenameFilter _filter;
        Comparator<File> _comp;

        public DirectoryIterator(String root, FilenameFilter filter) {
            this(root, filter, (Comparator<File>)new DefaultComparator());
        }

        public DirectoryIterator(String root, FilenameFilter filter, Comparator<File> file_comparator) {
            this._root = root;
            this._filter = filter;
            this._comp = file_comparator;
            if (this._comp == null) {
                this._comp = new DefaultComparator();
            }
        }

        public DirectoryIterator(String root, String[] extensions, Comparator<File> file_comparator) {
            this(root, new ExtensionFilter(extensions), file_comparator);
        }

        public void iterate(FileHandler fh, DirectoryHandler dh) throws Exception {
            this.iterateDirectory(this._root, "", fh, dh);
        }

        void iterateDirectory(String dir_path, String local_path, FileHandler fh, DirectoryHandler dh) throws Exception {
            File dir = new File(dir_path);
            if (dh != null) {
                dh.processDirectory(dir, local_path);
            }
            File[] files = dir.listFiles(this._filter);
            Arrays.sort(files, this._comp);
            for (int i = 0; i < files.length; ++i) {
                String new_local_path;
                String string = new_local_path = local_path.length() == 0 ? files[i].getName() : local_path + File.separator + files[i].getName();
                if (files[i].isDirectory()) {
                    this.iterateDirectory(dir_path + File.separator + files[i].getName(), new_local_path, fh, dh);
                    continue;
                }
                if (fh == null) continue;
                fh.processFile(files[i], new_local_path);
            }
        }

        public static interface FileHandler {
            public void processFile(File var1, String var2) throws Exception;
        }

        static class ExtensionFilter
        implements FilenameFilter {
            String[] _exts;

            ExtensionFilter(String[] exts) {
                this._exts = exts;
            }

            public boolean accept(File dir, String name) {
                if (new File(dir.getPath() + File.separator + name).isDirectory()) {
                    return true;
                }
                for (int i = 0; i < this._exts.length; ++i) {
                    if (!name.endsWith("." + this._exts[i])) continue;
                    return true;
                }
                return false;
            }
        }

        public static interface DirectoryHandler {
            public void processDirectory(File var1, String var2) throws Exception;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class DefaultComparator
        implements Comparator<File> {
            DefaultComparator() {
            }

            @Override
            public int compare(File f1, File f2) {
                int res = 0;
                if (f1.isDirectory()) {
                    res -= 10000;
                }
                if (f2.isDirectory()) {
                    res += 10000;
                }
                if (res != 0) {
                    return res;
                }
                return f1.getName().compareTo(f2.getName());
            }
        }
    }

    public static class CacheMap {
        HashMap<File, LTMValue> _map = new HashMap();

        public Object get(File key) {
            LTMValue ltm = this._map.get(key);
            if (ltm == null || ltm.lastModified != key.lastModified()) {
                return null;
            }
            return ltm.value;
        }

        public void put(File key, Object value) {
            LTMValue ltm = new LTMValue();
            ltm.lastModified = key.lastModified();
            ltm.value = value;
            this._map.put(key, ltm);
        }

        static class LTMValue {
            long lastModified;
            Object value;

            LTMValue() {
            }
        }
    }
}

