/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumUtils {
    public static String getName(Enum<?> constant) {
        return constant.name();
    }

    public static Object valueOf(Class enumClass, String constantName) {
        return Enum.valueOf(enumClass, constantName);
    }

    public static String[] getNames(Object[] constants) {
        ArrayList<String> names = new ArrayList<String>();
        for (Object constant : constants) {
            if (constant == null) continue;
            names.add(EnumUtils.getName((Enum)constant));
        }
        return names.toArray(new String[names.size()]);
    }

    public static String[] getValues(Object[] constants) {
        ArrayList<String> values = new ArrayList<String>();
        for (Object constant : constants) {
            values.add(((Enum)constant).toString());
        }
        return values.toArray(new String[values.size()]);
    }

    public static String[] getNames(Class<?> enumClass) {
        Object[] constants = EnumUtils.getEnumConstants(enumClass);
        return EnumUtils.getNames(constants);
    }

    public static String[] getValues(Class<?> enumClass) {
        Object[] constants = EnumUtils.getEnumConstants(enumClass);
        ArrayList<String> values = new ArrayList<String>();
        for (Object constant : constants) {
            values.add(((Enum)constant).toString());
        }
        return values.toArray(new String[values.size()]);
    }

    public static Object[] getEnumConstants(Class<?> enumClass) {
        if (!enumClass.isEnum()) {
            throw new IllegalArgumentException("The Class must be a enum");
        }
        return enumClass.getEnumConstants();
    }

    public static boolean isEnum(Object value) {
        return value != null && value.getClass().isEnum();
    }

    public static boolean isEnumArray(Object value) {
        return value != null && value.getClass().isArray() && value.getClass().getComponentType().isEnum();
    }
}

