/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import java.util.Date;
import java.util.GregorianCalendar;

public class DateDifference {
    private static final double DAY_MILLIS = 8.64054E7;
    private static final double WEEK_MILLIS = 6.048378E8;
    private static final double MONTH_MILLIS = 2.62989955845E9;
    private static final double YEAR_MILLIS = 3.157253316E10;

    private DateDifference() {
    }

    public static int getDifferenceInDays(Date endDate, Date startDate) {
        return DateDifference.getDateDiff(5, endDate, startDate);
    }

    public static int getDifferenceInWeeks(Date endDate, Date startDate) {
        return DateDifference.getDateDiff(3, endDate, startDate);
    }

    public static int getDifferenceInMonths(Date endDate, Date startDate) {
        return DateDifference.getDateDiff(2, endDate, startDate);
    }

    public static int getDifferenceInYears(Date endDate, Date startDate) {
        return DateDifference.getDateDiff(1, endDate, startDate);
    }

    private static int getDateDiff(int calUnit, Date endDate, Date startDate) {
        boolean neg = false;
        if (startDate.after(endDate)) {
            Date temp = startDate;
            startDate = endDate;
            endDate = temp;
            neg = true;
        }
        int estimate = DateDifference.getEstDiff(calUnit, startDate, endDate);
        GregorianCalendar calendarStartDate = new GregorianCalendar();
        calendarStartDate.setTime(startDate);
        GregorianCalendar calendarEndDate = new GregorianCalendar();
        calendarEndDate.setTime(endDate);
        calendarStartDate.add(calUnit, estimate - 2);
        int i = estimate - 1;
        while (true) {
            calendarStartDate.add(calUnit, 1);
            if (calendarStartDate.after(calendarEndDate)) {
                return neg ? 1 - i : i - 1;
            }
            ++i;
        }
    }

    private static int getEstDiff(int calUnit, Date d1, Date d2) {
        long diff = d2.getTime() - d1.getTime();
        switch (calUnit) {
            case 5: {
                return (int)((double)diff / 8.64054E7 + 0.5);
            }
            case 3: {
                return (int)((double)diff / 6.048378E8 + 0.5);
            }
            case 2: {
                return (int)((double)diff / 2.62989955845E9 + 0.5);
            }
            case 1: {
                return (int)((double)diff / 3.157253316E10 + 0.5);
            }
        }
        return 0;
    }
}

