/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import org.apache.commons.lang.ArrayUtils;
import org.openl.util.ArrayTool;

public class BooleanUtils {
    private static String[] additionalTrueValues = new String[]{"y", "t"};
    private static String[] additionalFalseValues = new String[]{"n", "f"};

    public static boolean toBoolean(Object value) {
        Boolean bValue = BooleanUtils.toBooleanObject(value);
        if (bValue == null) {
            return false;
        }
        return bValue;
    }

    public static boolean toBoolean(Object value, boolean defaultValue) {
        return BooleanUtils.toBooleanObject(value, defaultValue);
    }

    public static Boolean toBooleanObject(Object value) {
        Boolean bValue = null;
        if (value instanceof String) {
            bValue = BooleanUtils.isAdditionalValue((String)value) ? BooleanUtils.getBooleanFromAdditionalValue((String)value) : org.apache.commons.lang.BooleanUtils.toBooleanObject((String)((String)value));
        } else if (value instanceof Integer) {
            bValue = org.apache.commons.lang.BooleanUtils.toBoolean((int)((Integer)value));
        } else if (value instanceof Boolean) {
            bValue = (Boolean)value;
        }
        return bValue;
    }

    public static Boolean toBooleanObject(Object value, Boolean defaultValue) {
        Boolean bValue = BooleanUtils.toBooleanObject(value);
        return bValue == null ? defaultValue : bValue;
    }

    private static Boolean getBooleanFromAdditionalValue(String value) {
        Boolean result = null;
        String lcase = value.toLowerCase().intern();
        if (ArrayUtils.contains((Object[])additionalTrueValues, (Object)lcase)) {
            result = Boolean.TRUE;
        }
        if (ArrayUtils.contains((Object[])additionalFalseValues, (Object)lcase)) {
            result = Boolean.FALSE;
        }
        return result;
    }

    private static boolean isAdditionalValue(String value) {
        String lcaseValue = value.toLowerCase().intern();
        return ArrayUtils.contains((Object[])additionalTrueValues, (Object)lcaseValue) || ArrayUtils.contains((Object[])additionalFalseValues, (Object)lcaseValue);
    }

    public static boolean and(boolean[] values) {
        if (values == null) {
            return false;
        }
        for (boolean value : values) {
            if (value) continue;
            return false;
        }
        return true;
    }

    public static boolean and(Boolean[] values) {
        if (values == null) {
            return false;
        }
        if (ArrayTool.contains(values, null)) {
            return false;
        }
        for (Boolean value : values) {
            if (value.booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static boolean xor(boolean[] values) {
        if (values == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("Array is empty");
        }
        boolean result = values[0];
        for (int i = 1; i < values.length; ++i) {
            result ^= values[i];
        }
        return result;
    }

    public static boolean xor(Boolean[] values) {
        if (values == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("Array is empty");
        }
        if (ArrayTool.contains(values, null)) {
            throw new IllegalArgumentException("Array shouldn`t contain null objects");
        }
        Boolean result = values[0];
        for (int i = 1; i < values.length; ++i) {
            result = result ^ values[i];
        }
        return result;
    }

    public static boolean or(boolean[] values) {
        if (values == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("Array is empty");
        }
        boolean result = values[0];
        for (int i = 1; i < values.length; ++i) {
            result = result || values[i];
        }
        return result;
    }

    public static boolean or(Boolean[] values) {
        if (values == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("Array is empty");
        }
        if (ArrayTool.contains(values, null)) {
            throw new IllegalArgumentException("Array shouldn`t contain null objects");
        }
        Boolean result = values[0];
        for (int i = 1; i < values.length; ++i) {
            result = result != false || values[i] != false;
        }
        return result;
    }
}

