/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import java.util.Collection;
import org.openl.util.IAppender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Appender<T>
implements IAppender<T> {
    public static final IAppender<?> NUL = new Appender();

    public static <T> IAppender<T> toArray(T[] ary) {
        return new ArrayAppender<T>(ary);
    }

    public static <T> IAppender<T> toArray(T[] ary, int from, int to) {
        return new ArrayAppender<T>(ary, from, to);
    }

    public static <T> IAppender<T> toCollection(Collection<T> cc) {
        return new CollectionAppender<T>(cc);
    }

    @Override
    public boolean add(Object obj) {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CollectionAppender<T>
    implements IAppender<T> {
        Collection<T> collection;

        CollectionAppender(Collection<T> collection) {
            this.collection = collection;
        }

        @Override
        public boolean add(T obj) {
            this.collection.add(obj);
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ArrayAppender<T>
    implements IAppender<T> {
        T[] ary;
        int from;
        int to;

        ArrayAppender(T[] ary) {
            this(ary, 0, ary.length);
        }

        ArrayAppender(T[] ary, int from, int to) {
            this.ary = ary;
            this.from = from;
            this.to = to;
        }

        @Override
        public boolean add(T obj) {
            if (this.from >= this.to) {
                return false;
            }
            this.ary[this.from++] = obj;
            return true;
        }
    }
}

