/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import java.lang.reflect.Constructor;
import org.apache.commons.lang.StringUtils;
import org.openl.base.NamedThing;
import org.openl.util.IStringBoolOperator;
import org.openl.util.RuntimeExceptionWrapper;
import org.openl.util.StringTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AStringBoolOperator
extends NamedThing
implements IStringBoolOperator {
    private static Class<?>[] allTypes = new Class[]{ContainsOperator.class, MatchesOperator.class, EqualsOperator.class, EqualsIgnoreCaseOperator.class, StartsWithOperator.class, EndsWithOperator.class};
    private String sampleStr;

    public static String[] getAllOperatorNames() {
        String[] res = new String[allTypes.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = AStringBoolOperator.getOperatorName(allTypes[i]);
        }
        return res;
    }

    public static Class<?> findOperatorClass(String name) {
        for (int i = 0; i < allTypes.length; ++i) {
            Class<?> c = allTypes[i];
            if (!AStringBoolOperator.getOperatorName(c).equals(name)) continue;
            return c;
        }
        return null;
    }

    public static AStringBoolOperator makeOperator(String name, String sample) {
        Class<?> c = AStringBoolOperator.findOperatorClass(name);
        if (c == null) {
            throw new RuntimeException("Operator not found: " + name);
        }
        try {
            Constructor<?> constructor = c.getConstructor(String.class);
            AStringBoolOperator operator = (AStringBoolOperator)constructor.newInstance(sample);
            return operator;
        }
        catch (Throwable t) {
            throw RuntimeExceptionWrapper.wrap(t);
        }
    }

    private static String getOperatorName(Class<?> c) {
        String cname = StringTool.lastToken(c.getName(), "$");
        String name = StringTool.decapitalizeName(cname, " ");
        name = name.substring(0, name.length() - " operator".length());
        return name;
    }

    public AStringBoolOperator(String name, String sample) {
        super(name);
        this.sampleStr = sample;
    }

    @Override
    public String getSample() {
        return this.sampleStr;
    }

    @Override
    public boolean isMatching(String test) {
        return this.isMatching(this.sampleStr, test);
    }

    public abstract boolean isMatching(String var1, String var2);

    public boolean opReverse(String test) {
        return this.isMatching(test, this.sampleStr);
    }

    public void setSample(String sample) {
        this.sampleStr = sample;
    }

    public static class StartsWithOperator
    extends AStringBoolOperator {
        public StartsWithOperator(String sample) {
            super("starts with", sample);
        }

        public boolean isMatching(String sample, String test) {
            return test.startsWith(sample);
        }
    }

    public static class MatchesOperator
    extends AStringBoolOperator {
        public MatchesOperator(String sample) {
            super("matches", sample);
        }

        public boolean isMatching(String sample, String test) {
            return test.matches(sample);
        }
    }

    public static class Holder {
        private AStringBoolOperator operator;
        private String name = "equals";
        private String sample = "";

        public Holder(String opType, String value2) {
            this.setName(opType);
        }

        public String getName() {
            return this.name;
        }

        public String getSample() {
            return this.sample;
        }

        public boolean op(String test) {
            return this.operator.isMatching(test);
        }

        public void setName(String name) {
            this.name = name;
            this.operator = AStringBoolOperator.makeOperator(name, this.sample);
        }

        public void setSample(String sample) {
            this.sample = sample;
            if (this.operator != null) {
                this.operator.setSample(sample);
            }
        }
    }

    public static class EqualsOperator
    extends AStringBoolOperator {
        public EqualsOperator(String sample) {
            super("equals", sample);
        }

        public boolean isMatching(String sample, String test) {
            return test.equals(sample);
        }
    }

    public static class EqualsIgnoreCaseOperator
    extends AStringBoolOperator {
        public EqualsIgnoreCaseOperator(String sample) {
            super("equals ignore case", sample);
        }

        public boolean isMatching(String sample, String test) {
            return test.equalsIgnoreCase(sample);
        }
    }

    public static class EndsWithOperator
    extends AStringBoolOperator {
        public EndsWithOperator(String sample) {
            super("ends with", sample);
        }

        public boolean isMatching(String sample, String test) {
            return test.endsWith(sample);
        }
    }

    public static class ContainsIgnoreCaseOperator
    extends AStringBoolOperator {
        public ContainsIgnoreCaseOperator(String sample) {
            super("contains  ignore case", sample);
        }

        public boolean isMatching(String sample, String test) {
            return StringUtils.containsIgnoreCase((String)test, (String)sample);
        }
    }

    public static class ContainsOperator
    extends AStringBoolOperator {
        public ContainsOperator(String sample) {
            super("contains", sample);
        }

        public boolean isMatching(String sample, String test) {
            return test != null && test.indexOf(sample) >= 0;
        }
    }
}

