/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import org.openl.util.AStringConvertor;
import org.openl.util.ISelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ASelector<T>
implements ISelector<T> {
    public static <T> ISelector<T> selectAll(T obj) {
        return new AllSelector();
    }

    public static <T> ISelector<T> selectClass(Class<T> c) {
        return new ClassSelector<T>(c);
    }

    public static <T> ISelector<T> selectNone(T obj) {
        return new NoneSelector();
    }

    public static <T> ISelector<T> selectObject(T obj) {
        return new ObjectSelector<T>(obj);
    }

    @Override
    public ISelector<T> and(ISelector<T> isel) {
        return new ANDSelector<T>(this, isel);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsSelector((ASelector)obj);
    }

    protected boolean equalsSelector(ASelector<T> sel) {
        return sel == this;
    }

    public int hashCode() {
        return this.redefinedHashCode();
    }

    @Override
    public ISelector<T> not() {
        return new NOTSelector(this);
    }

    @Override
    public ISelector<T> or(ISelector<T> isel) {
        return new ORSelector<T>(this, isel);
    }

    protected int redefinedHashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public ISelector<T> xor(ISelector<T> isel) {
        return new XORSelector<T>(this, isel);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class XORSelector<T>
    extends BoolBinSelector<T> {
        public XORSelector(ISelector<T> sel1, ISelector<T> sel2) {
            super(sel1, sel2);
        }

        @Override
        public boolean select(T obj) {
            return this.sel1.select(obj) ^ this.sel2.select(obj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringValueSelector<T>
    extends ASelector<T> {
        String value;
        AStringConvertor<T> convertor;

        public StringValueSelector(String value, AStringConvertor<T> convertor) {
            this.value = value;
            this.convertor = convertor;
        }

        @Override
        protected boolean equalsSelector(ASelector<T> sel) {
            StringValueSelector svs = (StringValueSelector)sel;
            return this.value.equals(svs.value) && this.convertor.equals(svs.convertor);
        }

        @Override
        protected int redefinedHashCode() {
            return this.value.hashCode() * 37 + this.convertor.hashCode();
        }

        @Override
        public boolean select(T obj) {
            return this.value.equals(this.convertor.getStringValue(obj));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ORSelector<T>
    extends BoolBinSelector<T> {
        public ORSelector(ISelector<T> sel1, ISelector<T> sel2) {
            super(sel1, sel2);
        }

        @Override
        public boolean select(T obj) {
            if (this.sel1.select(obj)) {
                return true;
            }
            return this.sel2.select(obj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ObjectSelector<T>
    extends ASelector<T> {
        T myobj;

        public ObjectSelector(T obj) {
            this.myobj = obj;
        }

        @Override
        protected boolean equalsSelector(ASelector<T> sel) {
            return this.select(((ObjectSelector)sel).myobj);
        }

        @Override
        protected int redefinedHashCode() {
            return this.myobj == null ? 0 : this.myobj.hashCode();
        }

        @Override
        public boolean select(T obj) {
            if (this.myobj == obj) {
                return true;
            }
            if (this.myobj == null) {
                return false;
            }
            return this.myobj.equals(obj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NOTSelector<T>
    extends ASelector<T> {
        ISelector<T> is;

        public NOTSelector(ISelector<T> is) {
            this.is = is;
        }

        @Override
        protected boolean equalsSelector(ASelector<T> sel) {
            return this.is.equals(((NOTSelector)sel).is);
        }

        @Override
        protected int redefinedHashCode() {
            return this.is.hashCode();
        }

        @Override
        public boolean select(T obj) {
            return !this.is.select(obj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NoneSelector<T>
    extends ASelector<T> {
        NoneSelector() {
        }

        @Override
        public boolean select(T obj) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class IntValueSelector<T>
    extends ASelector<T> {
        int value;

        public IntValueSelector(int value) {
            this.value = value;
        }

        @Override
        protected boolean equalsSelector(ASelector<T> sel) {
            return ((IntValueSelector)sel).value == this.value;
        }

        protected abstract int getIntValue(T var1);

        @Override
        protected int redefinedHashCode() {
            return this.value;
        }

        @Override
        public boolean select(T obj) {
            return this.value == this.getIntValue(obj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassSelector<T>
    extends ASelector<T> {
        Class<T> c;

        public ClassSelector(Class<T> c) {
            this.c = c;
        }

        @Override
        protected boolean equalsSelector(ASelector<T> sel) {
            return this.c == ((ClassSelector)sel).c;
        }

        @Override
        protected int redefinedHashCode() {
            return this.c.hashCode();
        }

        @Override
        public boolean select(Object obj) {
            return this.c.isInstance(obj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class BoolBinSelector<T>
    extends ASelector<T> {
        ISelector<T> sel1;
        ISelector<T> sel2;

        protected BoolBinSelector(ISelector<T> sel1, ISelector<T> sel2) {
            this.sel1 = sel1;
            this.sel2 = sel2;
        }

        @Override
        protected boolean equalsSelector(ASelector<T> sel) {
            BoolBinSelector x = null;
            if (sel == null || !(sel instanceof BoolBinSelector)) {
                return false;
            }
            x = (BoolBinSelector)sel;
            return this.sel1.equals(x.sel1) && this.sel2.equals(x.sel2);
        }

        @Override
        protected int redefinedHashCode() {
            return this.sel1.hashCode() + this.sel2.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ANDSelector<T>
    extends BoolBinSelector<T> {
        public ANDSelector(ISelector<T> sel1, ISelector<T> sel2) {
            super(sel1, sel2);
        }

        @Override
        public boolean select(T obj) {
            if (this.sel1.select(obj)) {
                return this.sel2.select(obj);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AllSelector<T>
    extends ASelector<T> {
        AllSelector() {
        }

        @Override
        public boolean select(T obj) {
            return true;
        }
    }
}

