/*
 * Decompiled with CFR 0.152.
 */
package org.openl.domain;

import java.util.Iterator;
import org.openl.domain.AIntIterator;
import org.openl.domain.FixedSizeDomain;
import org.openl.domain.IIntDomain;
import org.openl.domain.IIntIterator;
import org.openl.domain.IType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntRangeDomain
extends FixedSizeDomain<Integer>
implements IIntDomain {
    protected int min;
    protected int max;

    public IntRangeDomain(int min, int max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean contains(int value) {
        return this.min <= value && value <= this.max;
    }

    public boolean containsNumber(Number n) {
        return (double)this.min <= n.doubleValue() && n.doubleValue() <= (double)this.max;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof IntRangeDomain)) {
            return false;
        }
        IntRangeDomain other = (IntRangeDomain)obj;
        return this.min == other.min && this.max == other.max;
    }

    @Override
    public IType getElementType() {
        return null;
    }

    @Override
    public int getMax() {
        return this.max;
    }

    @Override
    public int getMin() {
        return this.min;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + this.min;
        hashCode = 31 * hashCode + this.max;
        return hashCode;
    }

    @Override
    public IIntIterator intIterator() {
        return new RangeIterator();
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.intIterator();
    }

    @Override
    public boolean selectObject(Integer n) {
        return this.containsNumber(n);
    }

    @Override
    public boolean selectType(IType type) {
        return true;
    }

    @Override
    public int size() {
        return this.max - this.min + 1;
    }

    public String toString() {
        return "[" + this.min + ".." + this.max + "]";
    }

    private class RangeIterator
    extends AIntIterator {
        private int current;

        RangeIterator() {
            this.current = IntRangeDomain.this.min - 1;
        }

        public boolean hasNext() {
            return this.current < IntRangeDomain.this.max;
        }

        public int nextInt() {
            return ++this.current;
        }

        public int size() {
            return IntRangeDomain.this.max - IntRangeDomain.this.min + 1;
        }
    }
}

