/*
 * Decompiled with CFR 0.152.
 */
package org.openl.config;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.config.ConfigProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigSet {
    private final Log log = LogFactory.getLog(ConfigSet.class);
    private Map<String, Object> properties = new HashMap<String, Object>();

    public void addProperties(Properties props) {
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            String value = props.getProperty(key);
            this.addProperty(key, value);
        }
    }

    public void addProperties(Map<String, Object> props) {
        if (props != null) {
            this.properties.putAll(props);
        }
    }

    public void addProperty(String name, String value) {
        if (value == null) {
            return;
        }
        if ((value = value.trim()).length() == 0) {
            return;
        }
        this.properties.put(name, value);
    }

    public void updateProperties(Collection<ConfigProperty<?>> props) {
        for (ConfigProperty<?> prop : props) {
            this.updateProperty(prop);
        }
    }

    public void updateProperty(ConfigProperty<?> prop) {
        Object objectValue = this.properties.get(prop.getName());
        if (objectValue == null) {
            return;
        }
        try {
            prop.setTextValue(objectValue.toString());
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to update ConfigProperty '" + prop.getName() + "' with value '" + objectValue.toString() + "'!"), (Throwable)e);
        }
    }
}

