/*
 * Decompiled with CFR 0.152.
 */
package org.openl.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.PriorityQueue;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.config.ConfigLocator;
import org.openl.config.ConfigProperty;
import org.openl.config.ConfigSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigManager {
    private final Log log = LogFactory.getLog(ConfigManager.class);
    private PriorityQueue<ConfigLocator> locators = new PriorityQueue();

    public void addLocator(ConfigLocator locator) {
        this.locators.add(locator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigSet createFromStream(InputStream is) {
        ConfigSet result = null;
        try {
            Properties props = new Properties();
            props.load(is);
            result = new ConfigSet();
            result.addProperties(props);
        }
        catch (IOException e) {
            this.log.error((Object)"Failed to load properties!", (Throwable)e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                this.log.error((Object)"Failed to close InputStream!", (Throwable)e);
            }
        }
        return result;
    }

    public ConfigSet locate(String configName) {
        for (ConfigLocator locator : this.locators) {
            InputStream is = locator.locate(configName);
            if (is == null) continue;
            return this.createFromStream(is);
        }
        this.log.warn((Object)("Failed to locate config '" + configName + "'"));
        return null;
    }

    public void updateProperties(String configName, Collection<ConfigProperty<?>> properties) {
        ConfigSet set = this.locate(configName);
        if (set == null) {
            return;
        }
        set.updateProperties(properties);
    }
}

