/*
 * Decompiled with CFR 0.152.
 */
package org.openjfx.gradle;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.GradleException;
import org.openjfx.gradle.JavaFXPlatform;

public enum JavaFXModule {
    BASE(new JavaFXModule[0]),
    GRAPHICS(BASE),
    CONTROLS(BASE, GRAPHICS),
    FXML(BASE, GRAPHICS),
    MEDIA(BASE, GRAPHICS),
    SWING(BASE, GRAPHICS),
    WEB(BASE, CONTROLS, GRAPHICS, MEDIA);

    static final String PREFIX_MODULE = "javafx.";
    private static final String PREFIX_ARTIFACT = "javafx-";
    private List<JavaFXModule> dependentModules;

    private JavaFXModule(JavaFXModule ... dependentModules) {
        this.dependentModules = List.of(dependentModules);
    }

    public static Optional<JavaFXModule> fromModuleName(String moduleName) {
        return Stream.of(JavaFXModule.values()).filter(javaFXModule -> moduleName.equals(javaFXModule.getModuleName())).findFirst();
    }

    public String getModuleName() {
        return PREFIX_MODULE + this.name().toLowerCase(Locale.ROOT);
    }

    public String getModuleJarFileName() {
        return this.getModuleName() + ".jar";
    }

    public String getArtifactName() {
        return PREFIX_ARTIFACT + this.name().toLowerCase(Locale.ROOT);
    }

    public String getPlatformJarFileName(String version, JavaFXPlatform platform) {
        return this.getArtifactName() + "-" + version + "-" + platform.getClassifier() + ".jar";
    }

    public static Set<JavaFXModule> getJavaFXModules(List<String> moduleNames) {
        JavaFXModule.validateModules(moduleNames);
        return moduleNames.stream().map(JavaFXModule::fromModuleName).flatMap(Optional::stream).flatMap(javaFXModule -> javaFXModule.getMavenDependencies().stream()).collect(Collectors.toSet());
    }

    public static void validateModules(List<String> moduleNames) {
        List invalidModules = moduleNames.stream().filter(module -> JavaFXModule.fromModuleName(module).isEmpty()).collect(Collectors.toList());
        if (!invalidModules.isEmpty()) {
            throw new GradleException("Found one or more invalid JavaFX module names: " + invalidModules);
        }
    }

    public List<JavaFXModule> getDependentModules() {
        return this.dependentModules;
    }

    public List<JavaFXModule> getMavenDependencies() {
        ArrayList<JavaFXModule> dependencies = new ArrayList<JavaFXModule>(this.dependentModules);
        dependencies.add(0, this);
        return dependencies;
    }
}

