/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.mac;

import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Map;
import java.util.TreeSet;

final class MacView
extends View {
    private static final long multiClickTime;
    private static final int multiClickMaxX;
    private static final int multiClickMaxY;

    MacView() {
    }

    private static native void _initIDs();

    private static native long _getMultiClickTime_impl();

    private static native int _getMultiClickMaxX_impl();

    private static native int _getMultiClickMaxY_impl();

    static long getMultiClickTime_impl() {
        return multiClickTime;
    }

    static int getMultiClickMaxX_impl() {
        return multiClickMaxX;
    }

    static int getMultiClickMaxY_impl() {
        return multiClickMaxY;
    }

    @Override
    protected native int _getNativeFrameBuffer(long var1);

    @Override
    protected native long _create(Map var1);

    @Override
    protected native int _getX(long var1);

    @Override
    protected native int _getY(long var1);

    @Override
    protected native void _setParent(long var1, long var3);

    @Override
    protected native boolean _close(long var1);

    @Override
    protected native void _scheduleRepaint(long var1);

    @Override
    protected native void _begin(long var1);

    @Override
    protected native void _end(long var1);

    @Override
    protected native boolean _enterFullscreen(long var1, boolean var3, boolean var4, boolean var5);

    @Override
    protected native void _exitFullscreen(long var1, boolean var3);

    @Override
    protected native void _enableInputMethodEvents(long var1, boolean var3);

    @Override
    protected void _uploadPixels(long l, Pixels pixels) {
        Buffer buffer = pixels.getPixels();
        if (buffer.isDirect()) {
            this._uploadPixelsDirect(l, buffer, pixels.getWidth(), pixels.getHeight(), pixels.getScaleX(), pixels.getScaleY());
        } else if (buffer.hasArray()) {
            if (pixels.getBytesPerComponent() == 1) {
                ByteBuffer byteBuffer = (ByteBuffer)buffer;
                this._uploadPixelsByteArray(l, byteBuffer.array(), byteBuffer.arrayOffset(), pixels.getWidth(), pixels.getHeight(), pixels.getScaleX(), pixels.getScaleY());
            } else {
                IntBuffer intBuffer = (IntBuffer)buffer;
                this._uploadPixelsIntArray(l, intBuffer.array(), intBuffer.arrayOffset(), pixels.getWidth(), pixels.getHeight(), pixels.getScaleX(), pixels.getScaleY());
            }
        } else {
            this._uploadPixelsDirect(l, pixels.asByteBuffer(), pixels.getWidth(), pixels.getHeight(), pixels.getScaleX(), pixels.getScaleY());
        }
    }

    native void _uploadPixelsDirect(long var1, Buffer var3, int var4, int var5, float var6, float var7);

    native void _uploadPixelsByteArray(long var1, byte[] var3, int var4, int var5, int var6, float var7, float var8);

    native void _uploadPixelsIntArray(long var1, int[] var3, int var4, int var5, int var6, float var7, float var8);

    @Override
    protected void notifyResize(int n, int n2) {
        Window window = this.getWindow();
        float f = window == null ? 1.0f : window.getPlatformScaleX();
        float f2 = window == null ? 1.0f : window.getPlatformScaleY();
        n = Math.round((float)n * f);
        n2 = Math.round((float)n2 * f2);
        super.notifyResize(n, n2);
    }

    @Override
    protected void notifyMouse(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, boolean bl2) {
        Window window = this.getWindow();
        float f = window == null ? 1.0f : window.getPlatformScaleX();
        float f2 = window == null ? 1.0f : window.getPlatformScaleY();
        n3 = Math.round((float)n3 * f);
        n4 = Math.round((float)n4 * f2);
        n5 = Math.round((float)n5 * f);
        n6 = Math.round((float)n6 * f2);
        super.notifyMouse(n, n2, n3, n4, n5, n6, n7, bl, bl2);
    }

    @Override
    protected long _getNativeView(long l) {
        return l;
    }

    protected native long _getNativeLayer(long var1);

    public long getNativeLayer() {
        return this._getNativeLayer(this.getNativeView());
    }

    protected native int _getNativeRemoteLayerId(long var1, String var3);

    @Override
    public int getNativeRemoteLayerId(String string) {
        return this._getNativeRemoteLayerId(this.getNativeLayer(), string);
    }

    protected native void _hostRemoteLayerId(long var1, int var3);

    public void hostRemoteLayerId(int n) {
        this._hostRemoteLayerId(this.getNativeLayer(), n);
    }

    protected void notifyInputMethodMac(String string, int n, int n2, int n3, int n4, int n5) {
        byte[] byArray = new byte[]{(byte)n};
        int[] nArray = new int[]{0, n2};
        if (n == 4) {
            this.notifyInputMethod(string, null, nArray, byArray, n2, n3, 0);
        } else if (n5 > 0 && string != null && string.length() > 0 && n4 >= 0 && n5 + n4 <= string.length()) {
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            treeSet.add(0);
            treeSet.add(n4);
            treeSet.add(n4 + n5);
            treeSet.add(string.length());
            int[] nArray2 = new int[treeSet.size()];
            int n6 = 0;
            Object object = treeSet.iterator();
            while (object.hasNext()) {
                int n7;
                nArray2[n6] = n7 = ((Integer)object.next()).intValue();
                ++n6;
            }
            object = new byte[nArray2.length - 1];
            for (n6 = 0; n6 < nArray2.length - 1; ++n6) {
                object[n6] = nArray2[n6] == n4 ? 1 : 2;
            }
            this.notifyInputMethod(string, nArray2, nArray2, (byte[])object, 0, n3, 0);
        } else {
            this.notifyInputMethod(string, null, nArray, byArray, 0, n3, 0);
        }
    }

    static {
        MacView._initIDs();
        multiClickTime = MacView._getMultiClickTime_impl();
        multiClickMaxX = MacView._getMultiClickMaxX_impl();
        multiClickMaxY = MacView._getMultiClickMaxY_impl();
    }
}

