/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.samples;

import java.io.PrintWriter;
import java.util.Random;
import org.openjdk.jol.info.GraphLayout;
import org.openjdk.jol.util.VMSupport;

public class JOLSample_20_Roots {
    static volatile Object sink;

    public static void main(String[] args) throws Exception {
        System.out.println(VMSupport.vmDetails());
        PrintWriter pw = new PrintWriter(System.out, true);
        L1 l1 = new L1();
        L2 l2 = new L2();
        L3 l3 = new L3();
        L4 l4 = new L4();
        L5 l5 = new L5();
        L6 l6 = new L6();
        l1.bind(l2);
        l2.bind(l3);
        l3.bind(l4);
        l4.bind(l5);
        l5.bind(l6);
        l6.bind(l1);
        L r = l1;
        l6 = null;
        l5 = null;
        l4 = null;
        l3 = null;
        l2 = null;
        l1 = null;
        long lastAddr = VMSupport.addressOf((Object)r);
        pw.printf("Fresh object is at %x%n", lastAddr);
        int moves = 0;
        for (int i = 0; i < 100000; ++i) {
            L s = r;
            while (!((s = s.link()) instanceof L1)) {
            }
            long cur = VMSupport.addressOf((Object)s);
            s = null;
            if (cur != lastAddr) {
                pw.printf("*** Move %2d, L1 is at %x%n", ++moves, cur);
                pw.println("*** Root is " + r.getClass());
                pw.println(GraphLayout.parseInstance((Object)r).toPrintable());
                Random random = new Random();
                for (int c = 0; c < random.nextInt(100); ++c) {
                    r = r.link();
                }
                lastAddr = cur;
            }
            for (int c = 0; c < 10000; ++c) {
                sink = new Object();
            }
        }
        pw.close();
    }

    public static class L6
    extends AL {
    }

    public static class L5
    extends AL {
    }

    public static class L4
    extends AL {
    }

    public static class L3
    extends AL {
    }

    public static class L2
    extends AL {
    }

    public static class L1
    extends AL {
    }

    public static abstract class AL
    implements L {
        L l;

        @Override
        public L link() {
            return this.l;
        }

        @Override
        public void bind(L l) {
            this.l = l;
        }
    }

    public static interface L {
        public L link();

        public void bind(L var1);
    }
}

