/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.samples;

import org.openjdk.jol.datamodel.DataModel;
import org.openjdk.jol.datamodel.Model32;
import org.openjdk.jol.datamodel.Model64;
import org.openjdk.jol.info.ClassLayout;
import org.openjdk.jol.layouters.CurrentLayouter;
import org.openjdk.jol.layouters.HotSpotLayouter;
import org.openjdk.jol.layouters.Layouter;

public class JOLSample_10_DataModels {
    private static final DataModel[] MODELS_JDK8 = new DataModel[]{new Model32(), new Model64(false, false), new Model64(true, true), new Model64(true, true, 16)};
    private static final DataModel[] MODELS_JDK15 = new DataModel[]{new Model64(false, true), new Model64(false, true, 16)};

    public static void main(String[] args) {
        HotSpotLayouter l;
        CurrentLayouter l2 = new CurrentLayouter();
        System.out.println("***** " + l2);
        System.out.println(ClassLayout.parseClass(A.class, (Layouter)l2).toPrintable());
        for (DataModel model : MODELS_JDK8) {
            l = new HotSpotLayouter(model, 8);
            System.out.println("***** " + l);
            System.out.println(ClassLayout.parseClass(A.class, (Layouter)l).toPrintable());
        }
        for (DataModel model : MODELS_JDK8) {
            l = new HotSpotLayouter(model, 15);
            System.out.println("***** " + l);
            System.out.println(ClassLayout.parseClass(A.class, (Layouter)l).toPrintable());
        }
        for (DataModel model : MODELS_JDK15) {
            l = new HotSpotLayouter(model, 15);
            System.out.println("***** " + l);
            System.out.println(ClassLayout.parseClass(A.class, (Layouter)l).toPrintable());
        }
    }

    public static class A {
        Object a;
        int b;
    }
}

