/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.samples;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.openjdk.jol.info.GraphLayout;
import org.openjdk.jol.vm.VM;

public class JOLSample_27_Colocation {
    public static volatile Object sink;

    public static void main(String[] args) throws Exception {
        int c;
        System.out.println(VM.current().details());
        for (int c2 = 0; c2 < 1000000; ++c2) {
            sink = new Object();
        }
        System.gc();
        int COUNT = 1000;
        ConcurrentHashMap<Object, Object> chm = new ConcurrentHashMap<Object, Object>();
        JOLSample_27_Colocation.addElements(1000, chm);
        GraphLayout.parseInstance((Object[])new Object[]{chm}).toImage("chm-1-new.png");
        for (c = 2; c <= 5; ++c) {
            GraphLayout.parseInstance((Object[])new Object[]{chm}).toImage("chm-" + c + "-gc.png");
            System.gc();
        }
        JOLSample_27_Colocation.addElements(1000, chm);
        for (c = 6; c <= 10; ++c) {
            GraphLayout.parseInstance((Object[])new Object[]{chm}).toImage("chm-" + c + "-more-gc.png");
            System.gc();
        }
    }

    private static void addElements(final int count, final Map<Object, Object> chm) throws InterruptedException {
        ExecutorService pool = Executors.newCachedThreadPool();
        Runnable task = new Runnable(){

            @Override
            public void run() {
                for (int c = 0; c < count; ++c) {
                    Object o = new Object();
                    chm.put(o, o);
                }
            }
        };
        for (int t = 0; t < Runtime.getRuntime().availableProcessors() * 2; ++t) {
            pool.submit(task);
        }
        pool.shutdown();
        pool.awaitTermination(1L, TimeUnit.DAYS);
    }
}

