/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.operations;

import org.openjdk.jol.info.ClassLayout;
import org.openjdk.jol.operations.ClasspathedOperation;

public class ObjectInternals
extends ClasspathedOperation {
    @Override
    public String label() {
        return "internals";
    }

    @Override
    public String description() {
        return "Show the object internals: field layout and default contents, object header";
    }

    @Override
    public void runWith(Class<?> klass) throws Exception {
        try {
            Object o = this.tryInstantiate(klass);
            System.out.println(ClassLayout.parseInstance((Object)o).toPrintable());
        }
        catch (NoSuchMethodException e) {
            System.out.println("Failed to find matching constructor, falling back to class-only introspection.");
            System.out.println();
            System.out.println(ClassLayout.parseClass(klass).toPrintable());
        }
        catch (IllegalAccessException e) {
            System.out.println("Failed to find matching constructor, falling back to class-only introspection.");
            System.out.println();
            System.out.println(ClassLayout.parseClass(klass).toPrintable());
        }
        catch (InstantiationException e) {
            System.out.println("Failed to find matching constructor, falling back to class-only introspection.");
            System.out.println();
            System.out.println(ClassLayout.parseClass(klass).toPrintable());
        }
    }
}

