/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol;

import java.util.ArrayList;
import java.util.Arrays;
import org.openjdk.jol.Operation;
import org.openjdk.jol.operations.HeapDump;
import org.openjdk.jol.operations.ObjectEstimates;
import org.openjdk.jol.operations.ObjectExternals;
import org.openjdk.jol.operations.ObjectFootprint;
import org.openjdk.jol.operations.ObjectIdealPacking;
import org.openjdk.jol.operations.ObjectInternals;
import org.openjdk.jol.operations.StringCompress;

public class Main {
    public static void main(String ... args) throws Exception {
        if (args.length < 1) {
            System.err.println("Usage: jol-cli.jar <mode> [optional arguments]*");
            System.err.println("  Use mode \"help\" to get the list of available modes.");
            System.exit(1);
        }
        String mode = args[0];
        ArrayList<Operation> operations = new ArrayList<Operation>();
        operations.add(new ObjectInternals());
        operations.add(new ObjectExternals());
        operations.add(new ObjectEstimates());
        operations.add(new ObjectFootprint());
        operations.add(new ObjectIdealPacking());
        operations.add(new StringCompress());
        operations.add(new HeapDump());
        if (mode.equals("help")) {
            System.out.println("Available modes: ");
            for (Operation op : operations) {
                System.out.printf("  %20s: %s%n", op.label(), op.description());
            }
            System.exit(0);
        }
        String[] modeArgs = Arrays.copyOfRange(args, 1, args.length);
        for (Operation op : operations) {
            if (!op.label().equals(mode)) continue;
            op.run(modeArgs);
        }
    }
}

