/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.operations;

import java.io.File;
import org.openjdk.jol.Operation;
import org.openjdk.jol.datamodel.DataModel;
import org.openjdk.jol.datamodel.Model32;
import org.openjdk.jol.heap.HeapDumpReader;
import org.openjdk.jol.info.ClassData;
import org.openjdk.jol.layouters.HotSpotLayouter;
import org.openjdk.jol.layouters.Layouter;
import org.openjdk.jol.layouters.RawLayouter;
import org.openjdk.jol.operations.EstimatedModels;
import org.openjdk.jol.util.Multiset;

public class HeapDumpEstimates
implements Operation {
    @Override
    public String label() {
        return "heapdump-estimates";
    }

    @Override
    public String description() {
        return "Consume the heap dump and simulate the class layout in different VM modes";
    }

    @Override
    public void run(String ... args) throws Exception {
        HotSpotLayouter l;
        if (args.length == 0) {
            System.err.println("Expected a hprof file name.");
            return;
        }
        String path = args[0];
        System.out.println("Heap Dump: " + path);
        System.out.println();
        HeapDumpReader reader = new HeapDumpReader(new File(path));
        Multiset data = reader.parse();
        long rawSize = 0L;
        RawLayouter rawLayouter = new RawLayouter((DataModel)new Model32());
        for (ClassData cd : data.keys()) {
            rawSize += rawLayouter.layout(cd).instanceSize() * data.count((Object)cd);
        }
        for (DataModel model : EstimatedModels.MODELS_JDK8) {
            l = new HotSpotLayouter(model, 8);
            this.simulateWith((Layouter)l, (Multiset<ClassData>)data, rawSize);
        }
        for (DataModel model : EstimatedModels.MODELS_JDK8) {
            l = new HotSpotLayouter(model, 15);
            this.simulateWith((Layouter)l, (Multiset<ClassData>)data, rawSize);
        }
        for (DataModel model : EstimatedModels.MODELS_JDK15) {
            l = new HotSpotLayouter(model, 15);
            this.simulateWith((Layouter)l, (Multiset<ClassData>)data, rawSize);
        }
        for (DataModel model : EstimatedModels.MODELS_LILLIPUT) {
            l = new HotSpotLayouter(model, 99);
            this.simulateWith((Layouter)l, (Multiset<ClassData>)data, rawSize);
        }
    }

    private void simulateWith(Layouter layouter, Multiset<ClassData> data, long rawSize) {
        System.out.println("***** " + layouter);
        long size = 0L;
        for (ClassData cd : data.keys()) {
            size += layouter.layout(cd).instanceSize() * data.count((Object)cd);
        }
        System.out.printf("  Total data size:   %d bytes%n", rawSize);
        System.out.printf("  Total object size: %d bytes%n", size);
        System.out.printf("  Object overhead:   %.1f%%%n", (double)(size - rawSize) * 100.0 / (double)size);
        System.out.println();
    }
}

