/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol;

import org.openjdk.jol.info.ClassLayout;
import org.openjdk.jol.util.VMSupport;

public class MainObjectInternals {
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("Usage: jol-internals.jar [class-name]*");
            System.exit(1);
        }
        System.out.println(VMSupport.vmDetails());
        for (String klassName : args) {
            try {
                Class<?> klass = Class.forName(klassName);
                try {
                    Object o = klass.newInstance();
                    System.out.println(ClassLayout.parseClass(klass).toPrintable(o));
                }
                catch (IllegalAccessException e) {
                    System.out.println("VM fails to invoke the default constructor, falling back to class-only introspection.");
                    System.out.println();
                    System.out.println(ClassLayout.parseClass(klass).toPrintable());
                }
                catch (InstantiationException e) {
                    System.out.println("VM fails to invoke the default constructor, falling back to class-only introspection.");
                    System.out.println();
                    System.out.println(ClassLayout.parseClass(klass).toPrintable());
                }
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
            }
        }
    }
}

