/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol;

import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jol.info.GraphLayout;

@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Fork(value=1)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@State(value=Scope.Benchmark)
public class GraphInstanceBench {
    @Param(value={"1", "100", "10000"})
    int size;
    private Integer[] arr;

    @Setup
    public void setup() {
        this.arr = new Integer[this.size];
        for (int c = 0; c < this.size; ++c) {
            this.arr[c] = new Integer(c);
        }
    }

    @Benchmark
    public GraphLayout onlyCollect() {
        return GraphLayout.parseInstance((Object[])new Object[]{this.arr});
    }

    @Benchmark
    public String toFootprint() {
        return GraphLayout.parseInstance((Object[])new Object[]{this.arr}).toFootprint();
    }

    @Benchmark
    public String toPrintable() {
        return GraphLayout.parseInstance((Object[])new Object[]{this.arr}).toPrintable();
    }

    @Benchmark
    public long totalCount() {
        return GraphLayout.parseInstance((Object[])new Object[]{this.arr}).totalCount();
    }

    @Benchmark
    public long totalSize() {
        return GraphLayout.parseInstance((Object[])new Object[]{this.arr}).totalSize();
    }
}

