/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.samples;

import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.AuxCounters;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@OutputTimeUnit(value=TimeUnit.SECONDS)
@Warmup(iterations=5, time=100, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=5, time=100, timeUnit=TimeUnit.MILLISECONDS)
@Fork(value=1)
public class JMHSample_23_AuxCounters {
    @Benchmark
    public void measure(AdditionalCounters counters) {
        if (Math.random() < 0.1) {
            ++counters.case1;
        } else {
            ++counters.case2;
        }
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(JMHSample_23_AuxCounters.class.getSimpleName()).build();
        new Runner(opt).run();
    }

    @AuxCounters
    @State(value=Scope.Thread)
    public static class AdditionalCounters {
        public int case1;
        public int case2;

        @Setup(value=Level.Iteration)
        public void clean() {
            this.case2 = 0;
            this.case1 = 0;
        }

        public int total() {
            return this.case1 + this.case2;
        }
    }
}

