/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.samples;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Group;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.TimeValue;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@State(value=Scope.Group)
public class JMHSample_30_Interrupts {
    private BlockingQueue<Integer> q;

    @Setup
    public void setup() {
        this.q = new ArrayBlockingQueue<Integer>(1);
    }

    @Group(value="Q")
    @Benchmark
    public Integer take() throws InterruptedException {
        return this.q.take();
    }

    @Group(value="Q")
    @Benchmark
    public void put() throws InterruptedException {
        this.q.put(42);
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(JMHSample_30_Interrupts.class.getSimpleName()).warmupIterations(5).measurementIterations(5).threads(2).forks(5).timeout(TimeValue.seconds((long)5L)).build();
        new Runner(opt).run();
    }
}

