/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.samples;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Fork(value=5)
@State(value=Scope.Benchmark)
public class JMHSample_39_MemoryAccess {
    public static final int N = 20000000;
    private int[] intArray = new int[20000000];
    private List<Integer> intList = new ArrayList<Integer>(20000000);
    private List<Integer> shuffledIntList = new ArrayList<Integer>(20000000);

    @Setup
    public void setup() {
        Random random = new Random(1234L);
        for (int i = 0; i < 20000000; ++i) {
            this.intArray[i] = random.nextInt();
            this.intList.add(this.intArray[i]);
            this.shuffledIntList.add(this.intArray[i]);
        }
        Collections.shuffle(this.shuffledIntList);
    }

    @Benchmark
    public long sumArray() {
        long sum = 0L;
        for (int i = 0; i < 20000000; ++i) {
            sum += (long)this.intArray[i];
        }
        return sum;
    }

    @Benchmark
    public long sumArrayList() {
        long sum = 0L;
        for (int i = 0; i < 20000000; ++i) {
            sum += (long)this.intList.get(i).intValue();
        }
        return sum;
    }

    @Benchmark
    public long sumArrayListShuffled() {
        long sum = 0L;
        for (int i = 0; i < 20000000; ++i) {
            sum += (long)this.shuffledIntList.get(i).intValue();
        }
        return sum;
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(".*" + JMHSample_39_MemoryAccess.class.getSimpleName() + ".*").build();
        new Runner(opt).run();
    }
}

