/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.samples;

import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Fork(value=1)
@State(value=Scope.Thread)
public class JMHSample_28_BlackholeHelpers {
    private Worker workerBaseline;
    private Worker workerRight;
    private Worker workerWrong;

    private double compute(double d) {
        for (int c = 0; c < 10; ++c) {
            d = d * d / Math.PI;
        }
        return d;
    }

    @Setup
    public void setup(final Blackhole bh) {
        this.workerBaseline = new Worker(){
            double x;

            @Override
            public void work() {
            }
        };
        this.workerWrong = new Worker(){
            double x;

            @Override
            public void work() {
                JMHSample_28_BlackholeHelpers.this.compute(this.x);
            }
        };
        this.workerRight = new Worker(){
            double x;

            @Override
            public void work() {
                bh.consume(JMHSample_28_BlackholeHelpers.this.compute(this.x));
            }
        };
    }

    @Benchmark
    public void baseline() {
        this.workerBaseline.work();
    }

    @Benchmark
    public void measureWrong() {
        this.workerWrong.work();
    }

    @Benchmark
    public void measureRight() {
        this.workerRight.work();
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(JMHSample_28_BlackholeHelpers.class.getSimpleName()).build();
        new Runner(opt).run();
    }

    public static interface Worker {
        public void work();
    }
}

