/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.samples;

import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.AuxCounters;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@OutputTimeUnit(value=TimeUnit.SECONDS)
@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Fork(value=1)
public class JMHSample_23_AuxCounters {
    @Benchmark
    public void splitBranch(OpCounters counters) {
        if (Math.random() < 0.1) {
            ++counters.case1;
        } else {
            ++counters.case2;
        }
    }

    @Benchmark
    public void runSETI(EventCounters counters) {
        float wowSignal;
        float random = (float)Math.random();
        if (random == (wowSignal = 0.7853982f)) {
            ++counters.wows;
        }
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(JMHSample_23_AuxCounters.class.getSimpleName()).build();
        new Runner(opt).run();
    }

    @State(value=Scope.Thread)
    @AuxCounters(value=AuxCounters.Type.OPERATIONS)
    public static class OpCounters {
        public int case1;
        public int case2;

        public int total() {
            return this.case1 + this.case2;
        }
    }

    @State(value=Scope.Thread)
    @AuxCounters(value=AuxCounters.Type.EVENTS)
    public static class EventCounters {
        public int wows;
    }
}

